package netana

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNetworkDiagnostic invokes the netana.CreateNetworkDiagnostic API synchronously
// api document: https://help.aliyun.com/api/netana/createnetworkdiagnostic.html
func (client *Client) CreateNetworkDiagnostic(request *CreateNetworkDiagnosticRequest) (response *CreateNetworkDiagnosticResponse, err error) {
	response = CreateCreateNetworkDiagnosticResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNetworkDiagnosticWithChan invokes the netana.CreateNetworkDiagnostic API asynchronously
// api document: https://help.aliyun.com/api/netana/createnetworkdiagnostic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateNetworkDiagnosticWithChan(request *CreateNetworkDiagnosticRequest) (<-chan *CreateNetworkDiagnosticResponse, <-chan error) {
	responseChan := make(chan *CreateNetworkDiagnosticResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNetworkDiagnostic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNetworkDiagnosticWithCallback invokes the netana.CreateNetworkDiagnostic API asynchronously
// api document: https://help.aliyun.com/api/netana/createnetworkdiagnostic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateNetworkDiagnosticWithCallback(request *CreateNetworkDiagnosticRequest, callback func(response *CreateNetworkDiagnosticResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNetworkDiagnosticResponse
		var err error
		defer close(result)
		response, err = client.CreateNetworkDiagnostic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNetworkDiagnosticRequest is the request struct for api CreateNetworkDiagnostic
type CreateNetworkDiagnosticRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	RequestParams        string           `position:"Query" name:"RequestParams"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	UserRequestId        string           `position:"Query" name:"UserRequestId"`
	Type                 string           `position:"Query" name:"Type"`
	RequestApiName       string           `position:"Query" name:"RequestApiName"`
	ErrorCode            string           `position:"Query" name:"ErrorCode"`
	ProductType          string           `position:"Query" name:"ProductType"`
	ResponseParams       string           `position:"Query" name:"ResponseParams"`
}

// CreateNetworkDiagnosticResponse is the response struct for api CreateNetworkDiagnostic
type CreateNetworkDiagnosticResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Status    string `json:"Status" xml:"Status"`
	Tpl       string `json:"Tpl" xml:"Tpl"`
	Params    string `json:"Params" xml:"Params"`
}

// CreateCreateNetworkDiagnosticRequest creates a request to invoke CreateNetworkDiagnostic API
func CreateCreateNetworkDiagnosticRequest() (request *CreateNetworkDiagnosticRequest) {
	request = &CreateNetworkDiagnosticRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Netana", "2018-10-18", "CreateNetworkDiagnostic", "Netana", "openAPI")
	return
}

// CreateCreateNetworkDiagnosticResponse creates a response to parse from CreateNetworkDiagnostic response
func CreateCreateNetworkDiagnosticResponse() (response *CreateNetworkDiagnosticResponse) {
	response = &CreateNetworkDiagnosticResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
