package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMediaCategory invokes the mts.UpdateMediaCategory API synchronously
func (client *Client) UpdateMediaCategory(request *UpdateMediaCategoryRequest) (response *UpdateMediaCategoryResponse, err error) {
	response = CreateUpdateMediaCategoryResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMediaCategoryWithChan invokes the mts.UpdateMediaCategory API asynchronously
func (client *Client) UpdateMediaCategoryWithChan(request *UpdateMediaCategoryRequest) (<-chan *UpdateMediaCategoryResponse, <-chan error) {
	responseChan := make(chan *UpdateMediaCategoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMediaCategory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMediaCategoryWithCallback invokes the mts.UpdateMediaCategory API asynchronously
func (client *Client) UpdateMediaCategoryWithCallback(request *UpdateMediaCategoryRequest, callback func(response *UpdateMediaCategoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMediaCategoryResponse
		var err error
		defer close(result)
		response, err = client.UpdateMediaCategory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMediaCategoryRequest is the request struct for api UpdateMediaCategory
type UpdateMediaCategoryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CateId               requests.Integer `position:"Query" name:"CateId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	MediaId              string           `position:"Query" name:"MediaId"`
}

// UpdateMediaCategoryResponse is the response struct for api UpdateMediaCategory
type UpdateMediaCategoryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateMediaCategoryRequest creates a request to invoke UpdateMediaCategory API
func CreateUpdateMediaCategoryRequest() (request *UpdateMediaCategoryRequest) {
	request = &UpdateMediaCategoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "UpdateMediaCategory", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateMediaCategoryResponse creates a response to parse from UpdateMediaCategory response
func CreateUpdateMediaCategoryResponse() (response *UpdateMediaCategoryResponse) {
	response = &UpdateMediaCategoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
