package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGatewayRouteHTTPRewrite invokes the mse.UpdateGatewayRouteHTTPRewrite API synchronously
func (client *Client) UpdateGatewayRouteHTTPRewrite(request *UpdateGatewayRouteHTTPRewriteRequest) (response *UpdateGatewayRouteHTTPRewriteResponse, err error) {
	response = CreateUpdateGatewayRouteHTTPRewriteResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGatewayRouteHTTPRewriteWithChan invokes the mse.UpdateGatewayRouteHTTPRewrite API asynchronously
func (client *Client) UpdateGatewayRouteHTTPRewriteWithChan(request *UpdateGatewayRouteHTTPRewriteRequest) (<-chan *UpdateGatewayRouteHTTPRewriteResponse, <-chan error) {
	responseChan := make(chan *UpdateGatewayRouteHTTPRewriteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGatewayRouteHTTPRewrite(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGatewayRouteHTTPRewriteWithCallback invokes the mse.UpdateGatewayRouteHTTPRewrite API asynchronously
func (client *Client) UpdateGatewayRouteHTTPRewriteWithCallback(request *UpdateGatewayRouteHTTPRewriteRequest, callback func(response *UpdateGatewayRouteHTTPRewriteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGatewayRouteHTTPRewriteResponse
		var err error
		defer close(result)
		response, err = client.UpdateGatewayRouteHTTPRewrite(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGatewayRouteHTTPRewriteRequest is the request struct for api UpdateGatewayRouteHTTPRewrite
type UpdateGatewayRouteHTTPRewriteRequest struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	Id              requests.Integer `position:"Query" name:"Id"`
	GatewayId       requests.Integer `position:"Query" name:"GatewayId"`
	HttpRewriteJSON string           `position:"Query" name:"HttpRewriteJSON"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
}

// UpdateGatewayRouteHTTPRewriteResponse is the response struct for api UpdateGatewayRouteHTTPRewrite
type UpdateGatewayRouteHTTPRewriteResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           int64  `json:"Data" xml:"Data"`
}

// CreateUpdateGatewayRouteHTTPRewriteRequest creates a request to invoke UpdateGatewayRouteHTTPRewrite API
func CreateUpdateGatewayRouteHTTPRewriteRequest() (request *UpdateGatewayRouteHTTPRewriteRequest) {
	request = &UpdateGatewayRouteHTTPRewriteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateGatewayRouteHTTPRewrite", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateGatewayRouteHTTPRewriteResponse creates a response to parse from UpdateGatewayRouteHTTPRewrite response
func CreateUpdateGatewayRouteHTTPRewriteResponse() (response *UpdateGatewayRouteHTTPRewriteResponse) {
	response = &UpdateGatewayRouteHTTPRewriteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
