package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateClusterSpec invokes the mse.UpdateClusterSpec API synchronously
func (client *Client) UpdateClusterSpec(request *UpdateClusterSpecRequest) (response *UpdateClusterSpecResponse, err error) {
	response = CreateUpdateClusterSpecResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateClusterSpecWithChan invokes the mse.UpdateClusterSpec API asynchronously
func (client *Client) UpdateClusterSpecWithChan(request *UpdateClusterSpecRequest) (<-chan *UpdateClusterSpecResponse, <-chan error) {
	responseChan := make(chan *UpdateClusterSpecResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateClusterSpec(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateClusterSpecWithCallback invokes the mse.UpdateClusterSpec API asynchronously
func (client *Client) UpdateClusterSpecWithCallback(request *UpdateClusterSpecRequest, callback func(response *UpdateClusterSpecResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateClusterSpecResponse
		var err error
		defer close(result)
		response, err = client.UpdateClusterSpec(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateClusterSpecRequest is the request struct for api UpdateClusterSpec
type UpdateClusterSpecRequest struct {
	*requests.RpcRequest
	ClusterSpecification string           `position:"Query" name:"ClusterSpecification"`
	MseSessionId         string           `position:"Query" name:"MseSessionId"`
	InstanceCount        requests.Integer `position:"Query" name:"InstanceCount"`
	ClusterId            string           `position:"Query" name:"ClusterId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	AcceptLanguage       string           `position:"Query" name:"AcceptLanguage"`
}

// UpdateClusterSpecResponse is the response struct for api UpdateClusterSpec
type UpdateClusterSpecResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           string `json:"Data" xml:"Data"`
}

// CreateUpdateClusterSpecRequest creates a request to invoke UpdateClusterSpec API
func CreateUpdateClusterSpecRequest() (request *UpdateClusterSpecRequest) {
	request = &UpdateClusterSpecRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateClusterSpec", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateClusterSpecResponse creates a response to parse from UpdateClusterSpec response
func CreateUpdateClusterSpecResponse() (response *UpdateClusterSpecResponse) {
	response = &UpdateClusterSpecResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
