package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListConfigTrack invokes the mse.ListConfigTrack API synchronously
func (client *Client) ListConfigTrack(request *ListConfigTrackRequest) (response *ListConfigTrackResponse, err error) {
	response = CreateListConfigTrackResponse()
	err = client.DoAction(request, response)
	return
}

// ListConfigTrackWithChan invokes the mse.ListConfigTrack API asynchronously
func (client *Client) ListConfigTrackWithChan(request *ListConfigTrackRequest) (<-chan *ListConfigTrackResponse, <-chan error) {
	responseChan := make(chan *ListConfigTrackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListConfigTrack(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListConfigTrackWithCallback invokes the mse.ListConfigTrack API asynchronously
func (client *Client) ListConfigTrackWithCallback(request *ListConfigTrackRequest, callback func(response *ListConfigTrackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListConfigTrackResponse
		var err error
		defer close(result)
		response, err = client.ListConfigTrack(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListConfigTrackRequest is the request struct for api ListConfigTrack
type ListConfigTrackRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	StartTs        requests.Integer `position:"Query" name:"StartTs"`
	PageNum        requests.Integer `position:"Query" name:"PageNum"`
	NamespaceId    string           `position:"Query" name:"NamespaceId"`
	RequestPars    string           `position:"Query" name:"RequestPars"`
	EndTs          requests.Integer `position:"Query" name:"EndTs"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	Group          string           `position:"Query" name:"Group"`
	Ip             string           `position:"Query" name:"Ip"`
	Reverse        requests.Boolean `position:"Query" name:"Reverse"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
	DataId         string           `position:"Query" name:"DataId"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// ListConfigTrackResponse is the response struct for api ListConfigTrack
type ListConfigTrackResponse struct {
	*responses.BaseResponse
	HttpCode   string  `json:"HttpCode" xml:"HttpCode"`
	PageSize   int64   `json:"PageSize" xml:"PageSize"`
	PageNumber int64   `json:"PageNumber" xml:"PageNumber"`
	TotalCount int64   `json:"TotalCount" xml:"TotalCount"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	Message    string  `json:"Message" xml:"Message"`
	ErrorCode  string  `json:"ErrorCode" xml:"ErrorCode"`
	Success    bool    `json:"Success" xml:"Success"`
	Traces     []Trace `json:"Traces" xml:"Traces"`
}

// CreateListConfigTrackRequest creates a request to invoke ListConfigTrack API
func CreateListConfigTrackRequest() (request *ListConfigTrackRequest) {
	request = &ListConfigTrackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListConfigTrack", "mse", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListConfigTrackResponse creates a response to parse from ListConfigTrack response
func CreateListConfigTrackResponse() (response *ListConfigTrackResponse) {
	response = &ListConfigTrackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
