package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetApplicationListWithMetircs invokes the mse.GetApplicationListWithMetircs API synchronously
func (client *Client) GetApplicationListWithMetircs(request *GetApplicationListWithMetircsRequest) (response *GetApplicationListWithMetircsResponse, err error) {
	response = CreateGetApplicationListWithMetircsResponse()
	err = client.DoAction(request, response)
	return
}

// GetApplicationListWithMetircsWithChan invokes the mse.GetApplicationListWithMetircs API asynchronously
func (client *Client) GetApplicationListWithMetircsWithChan(request *GetApplicationListWithMetircsRequest) (<-chan *GetApplicationListWithMetircsResponse, <-chan error) {
	responseChan := make(chan *GetApplicationListWithMetircsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetApplicationListWithMetircs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetApplicationListWithMetircsWithCallback invokes the mse.GetApplicationListWithMetircs API asynchronously
func (client *Client) GetApplicationListWithMetircsWithCallback(request *GetApplicationListWithMetircsRequest, callback func(response *GetApplicationListWithMetircsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetApplicationListWithMetircsResponse
		var err error
		defer close(result)
		response, err = client.GetApplicationListWithMetircs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetApplicationListWithMetircsRequest is the request struct for api GetApplicationListWithMetircs
type GetApplicationListWithMetircsRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	Source         string           `position:"Query" name:"Source"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	AppName        string           `position:"Query" name:"AppName"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	AppId          string           `position:"Query" name:"AppId"`
	Namespace      string           `position:"Query" name:"Namespace"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
	Region         string           `position:"Query" name:"Region"`
}

// GetApplicationListWithMetircsResponse is the response struct for api GetApplicationListWithMetircs
type GetApplicationListWithMetircsResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetApplicationListWithMetircsRequest creates a request to invoke GetApplicationListWithMetircs API
func CreateGetApplicationListWithMetircsRequest() (request *GetApplicationListWithMetircsRequest) {
	request = &GetApplicationListWithMetircsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GetApplicationListWithMetircs", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetApplicationListWithMetircsResponse creates a response to parse from GetApplicationListWithMetircs response
func CreateGetApplicationListWithMetircsResponse() (response *GetApplicationListWithMetircsResponse) {
	response = &GetApplicationListWithMetircsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
