package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMcubeWhitelist invokes the mpaas.UpdateMcubeWhitelist API synchronously
func (client *Client) UpdateMcubeWhitelist(request *UpdateMcubeWhitelistRequest) (response *UpdateMcubeWhitelistResponse, err error) {
	response = CreateUpdateMcubeWhitelistResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMcubeWhitelistWithChan invokes the mpaas.UpdateMcubeWhitelist API asynchronously
func (client *Client) UpdateMcubeWhitelistWithChan(request *UpdateMcubeWhitelistRequest) (<-chan *UpdateMcubeWhitelistResponse, <-chan error) {
	responseChan := make(chan *UpdateMcubeWhitelistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMcubeWhitelist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMcubeWhitelistWithCallback invokes the mpaas.UpdateMcubeWhitelist API asynchronously
func (client *Client) UpdateMcubeWhitelistWithCallback(request *UpdateMcubeWhitelistRequest, callback func(response *UpdateMcubeWhitelistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMcubeWhitelistResponse
		var err error
		defer close(result)
		response, err = client.UpdateMcubeWhitelist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMcubeWhitelistRequest is the request struct for api UpdateMcubeWhitelist
type UpdateMcubeWhitelistRequest struct {
	*requests.RpcRequest
	OnexFlag    requests.Boolean `position:"Body" name:"OnexFlag"`
	TenantId    string           `position:"Body" name:"TenantId"`
	Id          string           `position:"Body" name:"Id"`
	KeyIds      string           `position:"Body" name:"KeyIds"`
	OssUrl      string           `position:"Body" name:"OssUrl"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// UpdateMcubeWhitelistResponse is the response struct for api UpdateMcubeWhitelist
type UpdateMcubeWhitelistResponse struct {
	*responses.BaseResponse
	ResultMessage      string             `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode         string             `json:"ResultCode" xml:"ResultCode"`
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	AddWhitelistResult AddWhitelistResult `json:"AddWhitelistResult" xml:"AddWhitelistResult"`
}

// CreateUpdateMcubeWhitelistRequest creates a request to invoke UpdateMcubeWhitelist API
func CreateUpdateMcubeWhitelistRequest() (request *UpdateMcubeWhitelistRequest) {
	request = &UpdateMcubeWhitelistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "UpdateMcubeWhitelist", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateMcubeWhitelistResponse creates a response to parse from UpdateMcubeWhitelist response
func CreateUpdateMcubeWhitelistResponse() (response *UpdateMcubeWhitelistResponse) {
	response = &UpdateMcubeWhitelistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
