package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMcubeNebulaApps invokes the mpaas.ListMcubeNebulaApps API synchronously
func (client *Client) ListMcubeNebulaApps(request *ListMcubeNebulaAppsRequest) (response *ListMcubeNebulaAppsResponse, err error) {
	response = CreateListMcubeNebulaAppsResponse()
	err = client.DoAction(request, response)
	return
}

// ListMcubeNebulaAppsWithChan invokes the mpaas.ListMcubeNebulaApps API asynchronously
func (client *Client) ListMcubeNebulaAppsWithChan(request *ListMcubeNebulaAppsRequest) (<-chan *ListMcubeNebulaAppsResponse, <-chan error) {
	responseChan := make(chan *ListMcubeNebulaAppsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMcubeNebulaApps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMcubeNebulaAppsWithCallback invokes the mpaas.ListMcubeNebulaApps API asynchronously
func (client *Client) ListMcubeNebulaAppsWithCallback(request *ListMcubeNebulaAppsRequest, callback func(response *ListMcubeNebulaAppsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMcubeNebulaAppsResponse
		var err error
		defer close(result)
		response, err = client.ListMcubeNebulaApps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMcubeNebulaAppsRequest is the request struct for api ListMcubeNebulaApps
type ListMcubeNebulaAppsRequest struct {
	*requests.RpcRequest
	TenantId    string `position:"Body" name:"TenantId"`
	AppId       string `position:"Body" name:"AppId"`
	WorkspaceId string `position:"Body" name:"WorkspaceId"`
}

// ListMcubeNebulaAppsResponse is the response struct for api ListMcubeNebulaApps
type ListMcubeNebulaAppsResponse struct {
	*responses.BaseResponse
	ResultMessage             string                    `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode                string                    `json:"ResultCode" xml:"ResultCode"`
	RequestId                 string                    `json:"RequestId" xml:"RequestId"`
	ListMcubeNebulaAppsResult ListMcubeNebulaAppsResult `json:"ListMcubeNebulaAppsResult" xml:"ListMcubeNebulaAppsResult"`
}

// CreateListMcubeNebulaAppsRequest creates a request to invoke ListMcubeNebulaApps API
func CreateListMcubeNebulaAppsRequest() (request *ListMcubeNebulaAppsRequest) {
	request = &ListMcubeNebulaAppsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "ListMcubeNebulaApps", "", "")
	request.Method = requests.POST
	return
}

// CreateListMcubeNebulaAppsResponse creates a response to parse from ListMcubeNebulaApps response
func CreateListMcubeNebulaAppsResponse() (response *ListMcubeNebulaAppsResponse) {
	response = &ListMcubeNebulaAppsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
