package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMcdpEventById invokes the mpaas.DeleteMcdpEventById API synchronously
func (client *Client) DeleteMcdpEventById(request *DeleteMcdpEventByIdRequest) (response *DeleteMcdpEventByIdResponse, err error) {
	response = CreateDeleteMcdpEventByIdResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMcdpEventByIdWithChan invokes the mpaas.DeleteMcdpEventById API asynchronously
func (client *Client) DeleteMcdpEventByIdWithChan(request *DeleteMcdpEventByIdRequest) (<-chan *DeleteMcdpEventByIdResponse, <-chan error) {
	responseChan := make(chan *DeleteMcdpEventByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMcdpEventById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMcdpEventByIdWithCallback invokes the mpaas.DeleteMcdpEventById API asynchronously
func (client *Client) DeleteMcdpEventByIdWithCallback(request *DeleteMcdpEventByIdRequest, callback func(response *DeleteMcdpEventByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMcdpEventByIdResponse
		var err error
		defer close(result)
		response, err = client.DeleteMcdpEventById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMcdpEventByIdRequest is the request struct for api DeleteMcdpEventById
type DeleteMcdpEventByIdRequest struct {
	*requests.RpcRequest
	MpaasMappcenterMcdpEventDeleteJsonStr string `position:"Body" name:"MpaasMappcenterMcdpEventDeleteJsonStr"`
	TenantId                              string `position:"Body" name:"TenantId"`
	AppId                                 string `position:"Body" name:"AppId"`
	WorkspaceId                           string `position:"Body" name:"WorkspaceId"`
}

// DeleteMcdpEventByIdResponse is the response struct for api DeleteMcdpEventById
type DeleteMcdpEventByIdResponse struct {
	*responses.BaseResponse
	ResultMessage string                             `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                             `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                             `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInDeleteMcdpEventById `json:"ResultContent" xml:"ResultContent"`
}

// CreateDeleteMcdpEventByIdRequest creates a request to invoke DeleteMcdpEventById API
func CreateDeleteMcdpEventByIdRequest() (request *DeleteMcdpEventByIdRequest) {
	request = &DeleteMcdpEventByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "DeleteMcdpEventById", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteMcdpEventByIdResponse creates a response to parse from DeleteMcdpEventById response
func CreateDeleteMcdpEventByIdResponse() (response *DeleteMcdpEventByIdResponse) {
	response = &DeleteMcdpEventByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
