package mns_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Subscribe invokes the mns_open.Subscribe API synchronously
func (client *Client) Subscribe(request *SubscribeRequest) (response *SubscribeResponse, err error) {
	response = CreateSubscribeResponse()
	err = client.DoAction(request, response)
	return
}

// SubscribeWithChan invokes the mns_open.Subscribe API asynchronously
func (client *Client) SubscribeWithChan(request *SubscribeRequest) (<-chan *SubscribeResponse, <-chan error) {
	responseChan := make(chan *SubscribeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Subscribe(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubscribeWithCallback invokes the mns_open.Subscribe API asynchronously
func (client *Client) SubscribeWithCallback(request *SubscribeRequest, callback func(response *SubscribeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubscribeResponse
		var err error
		defer close(result)
		response, err = client.Subscribe(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubscribeRequest is the request struct for api Subscribe
type SubscribeRequest struct {
	*requests.RpcRequest
	TopicName           string `position:"Query" name:"TopicName"`
	MessageTag          string `position:"Query" name:"MessageTag"`
	Endpoint            string `position:"Query" name:"Endpoint"`
	SubscriptionName    string `position:"Query" name:"SubscriptionName"`
	NotifyStrategy      string `position:"Query" name:"NotifyStrategy"`
	NotifyContentFormat string `position:"Query" name:"NotifyContentFormat"`
	PushType            string `position:"Query" name:"PushType"`
}

// SubscribeResponse is the response struct for api Subscribe
type SubscribeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int64  `json:"Code" xml:"Code"`
	Status    string `json:"Status" xml:"Status"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateSubscribeRequest creates a request to invoke Subscribe API
func CreateSubscribeRequest() (request *SubscribeRequest) {
	request = &SubscribeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mns-open", "2022-01-19", "Subscribe", "mns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubscribeResponse creates a response to parse from Subscribe response
func CreateSubscribeResponse() (response *SubscribeResponse) {
	response = &SubscribeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
