package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LeaveMessageGroup invokes the live.LeaveMessageGroup API synchronously
func (client *Client) LeaveMessageGroup(request *LeaveMessageGroupRequest) (response *LeaveMessageGroupResponse, err error) {
	response = CreateLeaveMessageGroupResponse()
	err = client.DoAction(request, response)
	return
}

// LeaveMessageGroupWithChan invokes the live.LeaveMessageGroup API asynchronously
func (client *Client) LeaveMessageGroupWithChan(request *LeaveMessageGroupRequest) (<-chan *LeaveMessageGroupResponse, <-chan error) {
	responseChan := make(chan *LeaveMessageGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LeaveMessageGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LeaveMessageGroupWithCallback invokes the live.LeaveMessageGroup API asynchronously
func (client *Client) LeaveMessageGroupWithCallback(request *LeaveMessageGroupRequest, callback func(response *LeaveMessageGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LeaveMessageGroupResponse
		var err error
		defer close(result)
		response, err = client.LeaveMessageGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LeaveMessageGroupRequest is the request struct for api LeaveMessageGroup
type LeaveMessageGroupRequest struct {
	*requests.RpcRequest
	UserId              string           `position:"Body" name:"UserId"`
	BroadCastType       requests.Integer `position:"Body" name:"BroadCastType"`
	BroadCastStatistics requests.Boolean `position:"Body" name:"BroadCastStatistics"`
	GroupId             string           `position:"Body" name:"GroupId"`
	AppId               string           `position:"Body" name:"AppId"`
}

// LeaveMessageGroupResponse is the response struct for api LeaveMessageGroup
type LeaveMessageGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateLeaveMessageGroupRequest creates a request to invoke LeaveMessageGroup API
func CreateLeaveMessageGroupRequest() (request *LeaveMessageGroupRequest) {
	request = &LeaveMessageGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "LeaveMessageGroup", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateLeaveMessageGroupResponse creates a response to parse from LeaveMessageGroup response
func CreateLeaveMessageGroupResponse() (response *LeaveMessageGroupResponse) {
	response = &LeaveMessageGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
