package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMixStream invokes the live.DeleteMixStream API synchronously
func (client *Client) DeleteMixStream(request *DeleteMixStreamRequest) (response *DeleteMixStreamResponse, err error) {
	response = CreateDeleteMixStreamResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMixStreamWithChan invokes the live.DeleteMixStream API asynchronously
func (client *Client) DeleteMixStreamWithChan(request *DeleteMixStreamRequest) (<-chan *DeleteMixStreamResponse, <-chan error) {
	responseChan := make(chan *DeleteMixStreamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMixStream(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMixStreamWithCallback invokes the live.DeleteMixStream API asynchronously
func (client *Client) DeleteMixStreamWithCallback(request *DeleteMixStreamRequest, callback func(response *DeleteMixStreamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMixStreamResponse
		var err error
		defer close(result)
		response, err = client.DeleteMixStream(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMixStreamRequest is the request struct for api DeleteMixStream
type DeleteMixStreamRequest struct {
	*requests.RpcRequest
	AppName     string           `position:"Query" name:"AppName"`
	StreamName  string           `position:"Query" name:"StreamName"`
	MixStreamId string           `position:"Query" name:"MixStreamId"`
	DomainName  string           `position:"Query" name:"DomainName"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteMixStreamResponse is the response struct for api DeleteMixStream
type DeleteMixStreamResponse struct {
	*responses.BaseResponse
	MixStreamId string `json:"MixStreamId" xml:"MixStreamId"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteMixStreamRequest creates a request to invoke DeleteMixStream API
func CreateDeleteMixStreamRequest() (request *DeleteMixStreamRequest) {
	request = &DeleteMixStreamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteMixStream", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteMixStreamResponse creates a response to parse from DeleteMixStream response
func CreateDeleteMixStreamResponse() (response *DeleteMixStreamResponse) {
	response = &DeleteMixStreamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
