package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelMuteGroupUser invokes the live.CancelMuteGroupUser API synchronously
func (client *Client) CancelMuteGroupUser(request *CancelMuteGroupUserRequest) (response *CancelMuteGroupUserResponse, err error) {
	response = CreateCancelMuteGroupUserResponse()
	err = client.DoAction(request, response)
	return
}

// CancelMuteGroupUserWithChan invokes the live.CancelMuteGroupUser API asynchronously
func (client *Client) CancelMuteGroupUserWithChan(request *CancelMuteGroupUserRequest) (<-chan *CancelMuteGroupUserResponse, <-chan error) {
	responseChan := make(chan *CancelMuteGroupUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelMuteGroupUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelMuteGroupUserWithCallback invokes the live.CancelMuteGroupUser API asynchronously
func (client *Client) CancelMuteGroupUserWithCallback(request *CancelMuteGroupUserRequest, callback func(response *CancelMuteGroupUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelMuteGroupUserResponse
		var err error
		defer close(result)
		response, err = client.CancelMuteGroupUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelMuteGroupUserRequest is the request struct for api CancelMuteGroupUser
type CancelMuteGroupUserRequest struct {
	*requests.RpcRequest
	CancelMuteUserList *[]string        `position:"Body" name:"CancelMuteUserList"  type:"Repeated"`
	OperatorUserId     string           `position:"Body" name:"OperatorUserId"`
	BroadCastType      requests.Integer `position:"Body" name:"BroadCastType"`
	GroupId            string           `position:"Body" name:"GroupId"`
	AppId              string           `position:"Body" name:"AppId"`
}

// CancelMuteGroupUserResponse is the response struct for api CancelMuteGroupUser
type CancelMuteGroupUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCancelMuteGroupUserRequest creates a request to invoke CancelMuteGroupUser API
func CreateCancelMuteGroupUserRequest() (request *CancelMuteGroupUserRequest) {
	request = &CancelMuteGroupUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "CancelMuteGroupUser", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelMuteGroupUserResponse creates a response to parse from CancelMuteGroupUser response
func CreateCancelMuteGroupUserResponse() (response *CancelMuteGroupUserResponse) {
	response = &CancelMuteGroupUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
