package jarvis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateConsoleAccessWhiteList invokes the jarvis.CreateConsoleAccessWhiteList API synchronously
// api document: https://help.aliyun.com/api/jarvis/createconsoleaccesswhitelist.html
func (client *Client) CreateConsoleAccessWhiteList(request *CreateConsoleAccessWhiteListRequest) (response *CreateConsoleAccessWhiteListResponse, err error) {
	response = CreateCreateConsoleAccessWhiteListResponse()
	err = client.DoAction(request, response)
	return
}

// CreateConsoleAccessWhiteListWithChan invokes the jarvis.CreateConsoleAccessWhiteList API asynchronously
// api document: https://help.aliyun.com/api/jarvis/createconsoleaccesswhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateConsoleAccessWhiteListWithChan(request *CreateConsoleAccessWhiteListRequest) (<-chan *CreateConsoleAccessWhiteListResponse, <-chan error) {
	responseChan := make(chan *CreateConsoleAccessWhiteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateConsoleAccessWhiteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateConsoleAccessWhiteListWithCallback invokes the jarvis.CreateConsoleAccessWhiteList API asynchronously
// api document: https://help.aliyun.com/api/jarvis/createconsoleaccesswhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateConsoleAccessWhiteListWithCallback(request *CreateConsoleAccessWhiteListRequest, callback func(response *CreateConsoleAccessWhiteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateConsoleAccessWhiteListResponse
		var err error
		defer close(result)
		response, err = client.CreateConsoleAccessWhiteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateConsoleAccessWhiteListRequest is the request struct for api CreateConsoleAccessWhiteList
type CreateConsoleAccessWhiteListRequest struct {
	*requests.RpcRequest
	Note             string           `position:"Query" name:"Note"`
	ResourceOwnerId  requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SrcIP            string           `position:"Query" name:"SrcIP"`
	SourceIp         string           `position:"Query" name:"SourceIp"`
	DstPort          requests.Integer `position:"Query" name:"DstPort"`
	InstanceIdList   string           `position:"Query" name:"InstanceIdList"`
	LiveTime         requests.Integer `position:"Query" name:"LiveTime"`
	ProductName      string           `position:"Query" name:"ProductName"`
	WhiteListType    requests.Integer `position:"Query" name:"WhiteListType"`
	InstanceInfoList string           `position:"Query" name:"InstanceInfoList"`
	Lang             string           `position:"Query" name:"Lang"`
	SourceCode       string           `position:"Query" name:"SourceCode"`
}

// CreateConsoleAccessWhiteListResponse is the response struct for api CreateConsoleAccessWhiteList
type CreateConsoleAccessWhiteListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Module    string `json:"Module" xml:"Module"`
}

// CreateCreateConsoleAccessWhiteListRequest creates a request to invoke CreateConsoleAccessWhiteList API
func CreateCreateConsoleAccessWhiteListRequest() (request *CreateConsoleAccessWhiteListRequest) {
	request = &CreateConsoleAccessWhiteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis", "2018-02-06", "CreateConsoleAccessWhiteList", "jarvis", "openAPI")
	return
}

// CreateCreateConsoleAccessWhiteListResponse creates a response to parse from CreateConsoleAccessWhiteList response
func CreateCreateConsoleAccessWhiteListResponse() (response *CreateConsoleAccessWhiteListResponse) {
	response = &CreateConsoleAccessWhiteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
