package itaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateEnterpriseConfig invokes the itaas.UpdateEnterpriseConfig API synchronously
// api document: https://help.aliyun.com/api/itaas/updateenterpriseconfig.html
func (client *Client) UpdateEnterpriseConfig(request *UpdateEnterpriseConfigRequest) (response *UpdateEnterpriseConfigResponse, err error) {
	response = CreateUpdateEnterpriseConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateEnterpriseConfigWithChan invokes the itaas.UpdateEnterpriseConfig API asynchronously
// api document: https://help.aliyun.com/api/itaas/updateenterpriseconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateEnterpriseConfigWithChan(request *UpdateEnterpriseConfigRequest) (<-chan *UpdateEnterpriseConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateEnterpriseConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateEnterpriseConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateEnterpriseConfigWithCallback invokes the itaas.UpdateEnterpriseConfig API asynchronously
// api document: https://help.aliyun.com/api/itaas/updateenterpriseconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateEnterpriseConfigWithCallback(request *UpdateEnterpriseConfigRequest, callback func(response *UpdateEnterpriseConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateEnterpriseConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateEnterpriseConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateEnterpriseConfigRequest is the request struct for api UpdateEnterpriseConfig
type UpdateEnterpriseConfigRequest struct {
	*requests.RpcRequest
	ConfigKey   string `position:"Query" name:"ConfigKey"`
	Clientappid string `position:"Query" name:"Clientappid"`
	ConfigValue string `position:"Query" name:"ConfigValue"`
	Memo        string `position:"Query" name:"Memo"`
	Sysfrom     string `position:"Query" name:"Sysfrom"`
	Operator    string `position:"Query" name:"Operator"`
}

// UpdateEnterpriseConfigResponse is the response struct for api UpdateEnterpriseConfig
type UpdateEnterpriseConfigResponse struct {
	*responses.BaseResponse
	RequestId string                            `json:"RequestId" xml:"RequestId"`
	ErrorCode int                               `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string                            `json:"ErrorMsg" xml:"ErrorMsg"`
	Success   bool                              `json:"Success" xml:"Success"`
	ErrorList ErrorListInUpdateEnterpriseConfig `json:"ErrorList" xml:"ErrorList"`
}

// CreateUpdateEnterpriseConfigRequest creates a request to invoke UpdateEnterpriseConfig API
func CreateUpdateEnterpriseConfigRequest() (request *UpdateEnterpriseConfigRequest) {
	request = &UpdateEnterpriseConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ITaaS", "2017-05-05", "UpdateEnterpriseConfig", "itaas", "openAPI")
	return
}

// CreateUpdateEnterpriseConfigResponse creates a response to parse from UpdateEnterpriseConfig response
func CreateUpdateEnterpriseConfigResponse() (response *UpdateEnterpriseConfigResponse) {
	response = &UpdateEnterpriseConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
