package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSoundCode invokes the iot.UpdateSoundCode API synchronously
func (client *Client) UpdateSoundCode(request *UpdateSoundCodeRequest) (response *UpdateSoundCodeResponse, err error) {
	response = CreateUpdateSoundCodeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSoundCodeWithChan invokes the iot.UpdateSoundCode API asynchronously
func (client *Client) UpdateSoundCodeWithChan(request *UpdateSoundCodeRequest) (<-chan *UpdateSoundCodeResponse, <-chan error) {
	responseChan := make(chan *UpdateSoundCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSoundCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSoundCodeWithCallback invokes the iot.UpdateSoundCode API asynchronously
func (client *Client) UpdateSoundCodeWithCallback(request *UpdateSoundCodeRequest, callback func(response *UpdateSoundCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSoundCodeResponse
		var err error
		defer close(result)
		response, err = client.UpdateSoundCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSoundCodeRequest is the request struct for api UpdateSoundCode
type UpdateSoundCodeRequest struct {
	*requests.RpcRequest
	SoundCode        string           `position:"Body" name:"SoundCode"`
	Duration         requests.Integer `position:"Body" name:"Duration"`
	IotInstanceId    string           `position:"Body" name:"IotInstanceId"`
	SoundCodeContent string           `position:"Body" name:"SoundCodeContent"`
	ApiProduct       string           `position:"Body" name:"ApiProduct"`
	Name             string           `position:"Body" name:"Name"`
	ApiRevision      string           `position:"Body" name:"ApiRevision"`
}

// UpdateSoundCodeResponse is the response struct for api UpdateSoundCode
type UpdateSoundCodeResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateUpdateSoundCodeRequest creates a request to invoke UpdateSoundCode API
func CreateUpdateSoundCodeRequest() (request *UpdateSoundCodeRequest) {
	request = &UpdateSoundCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "UpdateSoundCode", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateSoundCodeResponse creates a response to parse from UpdateSoundCode response
func CreateUpdateSoundCodeResponse() (response *UpdateSoundCodeResponse) {
	response = &UpdateSoundCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
