package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDeviceGroupByDevice invokes the iot.QueryDeviceGroupByDevice API synchronously
func (client *Client) QueryDeviceGroupByDevice(request *QueryDeviceGroupByDeviceRequest) (response *QueryDeviceGroupByDeviceResponse, err error) {
	response = CreateQueryDeviceGroupByDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDeviceGroupByDeviceWithChan invokes the iot.QueryDeviceGroupByDevice API asynchronously
func (client *Client) QueryDeviceGroupByDeviceWithChan(request *QueryDeviceGroupByDeviceRequest) (<-chan *QueryDeviceGroupByDeviceResponse, <-chan error) {
	responseChan := make(chan *QueryDeviceGroupByDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDeviceGroupByDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDeviceGroupByDeviceWithCallback invokes the iot.QueryDeviceGroupByDevice API asynchronously
func (client *Client) QueryDeviceGroupByDeviceWithCallback(request *QueryDeviceGroupByDeviceRequest, callback func(response *QueryDeviceGroupByDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDeviceGroupByDeviceResponse
		var err error
		defer close(result)
		response, err = client.QueryDeviceGroupByDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDeviceGroupByDeviceRequest is the request struct for api QueryDeviceGroupByDevice
type QueryDeviceGroupByDeviceRequest struct {
	*requests.RpcRequest
	RealTenantId      string `position:"Query" name:"RealTenantId"`
	RealTripartiteKey string `position:"Query" name:"RealTripartiteKey"`
	IotInstanceId     string `position:"Query" name:"IotInstanceId"`
	ProductKey        string `position:"Query" name:"ProductKey"`
	ApiProduct        string `position:"Body" name:"ApiProduct"`
	ApiRevision       string `position:"Body" name:"ApiRevision"`
	DeviceName        string `position:"Query" name:"DeviceName"`
}

// QueryDeviceGroupByDeviceResponse is the response struct for api QueryDeviceGroupByDevice
type QueryDeviceGroupByDeviceResponse struct {
	*responses.BaseResponse
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	Success      bool       `json:"Success" xml:"Success"`
	Code         string     `json:"Code" xml:"Code"`
	ErrorMessage string     `json:"ErrorMessage" xml:"ErrorMessage"`
	GroupInfos   GroupInfos `json:"GroupInfos" xml:"GroupInfos"`
}

// CreateQueryDeviceGroupByDeviceRequest creates a request to invoke QueryDeviceGroupByDevice API
func CreateQueryDeviceGroupByDeviceRequest() (request *QueryDeviceGroupByDeviceRequest) {
	request = &QueryDeviceGroupByDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryDeviceGroupByDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryDeviceGroupByDeviceResponse creates a response to parse from QueryDeviceGroupByDevice response
func CreateQueryDeviceGroupByDeviceResponse() (response *QueryDeviceGroupByDeviceResponse) {
	response = &QueryDeviceGroupByDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
