package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetParser invokes the iot.GetParser API synchronously
func (client *Client) GetParser(request *GetParserRequest) (response *GetParserResponse, err error) {
	response = CreateGetParserResponse()
	err = client.DoAction(request, response)
	return
}

// GetParserWithChan invokes the iot.GetParser API asynchronously
func (client *Client) GetParserWithChan(request *GetParserRequest) (<-chan *GetParserResponse, <-chan error) {
	responseChan := make(chan *GetParserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetParser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetParserWithCallback invokes the iot.GetParser API asynchronously
func (client *Client) GetParserWithCallback(request *GetParserRequest, callback func(response *GetParserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetParserResponse
		var err error
		defer close(result)
		response, err = client.GetParser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetParserRequest is the request struct for api GetParser
type GetParserRequest struct {
	*requests.RpcRequest
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	ParserId      requests.Integer `position:"Query" name:"ParserId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// GetParserResponse is the response struct for api GetParser
type GetParserResponse struct {
	*responses.BaseResponse
	RequestId    string          `json:"RequestId" xml:"RequestId"`
	Success      bool            `json:"Success" xml:"Success"`
	Code         string          `json:"Code" xml:"Code"`
	ErrorMessage string          `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInGetParser `json:"Data" xml:"Data"`
}

// CreateGetParserRequest creates a request to invoke GetParser API
func CreateGetParserRequest() (request *GetParserRequest) {
	request = &GetParserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "GetParser", "", "")
	request.Method = requests.POST
	return
}

// CreateGetParserResponse creates a response to parse from GetParser response
func CreateGetParserResponse() (response *GetParserResponse) {
	response = &GetParserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
