package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateParser invokes the iot.CreateParser API synchronously
func (client *Client) CreateParser(request *CreateParserRequest) (response *CreateParserResponse, err error) {
	response = CreateCreateParserResponse()
	err = client.DoAction(request, response)
	return
}

// CreateParserWithChan invokes the iot.CreateParser API asynchronously
func (client *Client) CreateParserWithChan(request *CreateParserRequest) (<-chan *CreateParserResponse, <-chan error) {
	responseChan := make(chan *CreateParserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateParser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateParserWithCallback invokes the iot.CreateParser API asynchronously
func (client *Client) CreateParserWithCallback(request *CreateParserRequest, callback func(response *CreateParserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateParserResponse
		var err error
		defer close(result)
		response, err = client.CreateParser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateParserRequest is the request struct for api CreateParser
type CreateParserRequest struct {
	*requests.RpcRequest
	Description     string `position:"Query" name:"Description"`
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	IotInstanceId   string `position:"Query" name:"IotInstanceId"`
	ApiProduct      string `position:"Body" name:"ApiProduct"`
	Name            string `position:"Query" name:"Name"`
	ApiRevision     string `position:"Body" name:"ApiRevision"`
}

// CreateParserResponse is the response struct for api CreateParser
type CreateParserResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ParserId     int64  `json:"ParserId" xml:"ParserId"`
}

// CreateCreateParserRequest creates a request to invoke CreateParser API
func CreateCreateParserRequest() (request *CreateParserRequest) {
	request = &CreateParserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateParser", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateParserResponse creates a response to parse from CreateParser response
func CreateCreateParserResponse() (response *CreateParserResponse) {
	response = &CreateParserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
