package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDestination invokes the iot.CreateDestination API synchronously
func (client *Client) CreateDestination(request *CreateDestinationRequest) (response *CreateDestinationResponse, err error) {
	response = CreateCreateDestinationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDestinationWithChan invokes the iot.CreateDestination API asynchronously
func (client *Client) CreateDestinationWithChan(request *CreateDestinationRequest) (<-chan *CreateDestinationResponse, <-chan error) {
	responseChan := make(chan *CreateDestinationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDestination(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDestinationWithCallback invokes the iot.CreateDestination API asynchronously
func (client *Client) CreateDestinationWithCallback(request *CreateDestinationRequest, callback func(response *CreateDestinationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDestinationResponse
		var err error
		defer close(result)
		response, err = client.CreateDestination(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDestinationRequest is the request struct for api CreateDestination
type CreateDestinationRequest struct {
	*requests.RpcRequest
	Configuration string `position:"Query" name:"Configuration"`
	Description   string `position:"Query" name:"Description"`
	Type          string `position:"Query" name:"Type"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	Name          string `position:"Query" name:"Name"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// CreateDestinationResponse is the response struct for api CreateDestination
type CreateDestinationResponse struct {
	*responses.BaseResponse
	RequestId    string      `json:"RequestId" xml:"RequestId"`
	Success      bool        `json:"Success" xml:"Success"`
	Code         string      `json:"Code" xml:"Code"`
	ErrorMessage string      `json:"ErrorMessage" xml:"ErrorMessage"`
	Destination  Destination `json:"Destination" xml:"Destination"`
}

// CreateCreateDestinationRequest creates a request to invoke CreateDestination API
func CreateCreateDestinationRequest() (request *CreateDestinationRequest) {
	request = &CreateDestinationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateDestination", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDestinationResponse creates a response to parse from CreateDestination response
func CreateCreateDestinationResponse() (response *CreateDestinationResponse) {
	response = &CreateDestinationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
