package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSetTags invokes the imm.ListSetTags API synchronously
func (client *Client) ListSetTags(request *ListSetTagsRequest) (response *ListSetTagsResponse, err error) {
	response = CreateListSetTagsResponse()
	err = client.DoAction(request, response)
	return
}

// ListSetTagsWithChan invokes the imm.ListSetTags API asynchronously
func (client *Client) ListSetTagsWithChan(request *ListSetTagsRequest) (<-chan *ListSetTagsResponse, <-chan error) {
	responseChan := make(chan *ListSetTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSetTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSetTagsWithCallback invokes the imm.ListSetTags API asynchronously
func (client *Client) ListSetTagsWithCallback(request *ListSetTagsRequest, callback func(response *ListSetTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSetTagsResponse
		var err error
		defer close(result)
		response, err = client.ListSetTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSetTagsRequest is the request struct for api ListSetTags
type ListSetTagsRequest struct {
	*requests.RpcRequest
	Project string `position:"Query" name:"Project"`
	SetId   string `position:"Query" name:"SetId"`
}

// ListSetTagsResponse is the response struct for api ListSetTags
type ListSetTagsResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	SetId     string     `json:"SetId" xml:"SetId"`
	Tags      []TagsItem `json:"Tags" xml:"Tags"`
}

// CreateListSetTagsRequest creates a request to invoke ListSetTags API
func CreateListSetTagsRequest() (request *ListSetTagsRequest) {
	request = &ListSetTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "ListSetTags", "imm", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSetTagsResponse creates a response to parse from ListSetTags response
func CreateListSetTagsResponse() (response *ListSetTagsResponse) {
	response = &ListSetTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
