package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectLymph invokes the imageprocess.DetectLymph API synchronously
func (client *Client) DetectLymph(request *DetectLymphRequest) (response *DetectLymphResponse, err error) {
	response = CreateDetectLymphResponse()
	err = client.DoAction(request, response)
	return
}

// DetectLymphWithChan invokes the imageprocess.DetectLymph API asynchronously
func (client *Client) DetectLymphWithChan(request *DetectLymphRequest) (<-chan *DetectLymphResponse, <-chan error) {
	responseChan := make(chan *DetectLymphResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectLymph(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectLymphWithCallback invokes the imageprocess.DetectLymph API asynchronously
func (client *Client) DetectLymphWithCallback(request *DetectLymphRequest, callback func(response *DetectLymphResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectLymphResponse
		var err error
		defer close(result)
		response, err = client.DetectLymph(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectLymphRequest is the request struct for api DetectLymph
type DetectLymphRequest struct {
	*requests.RpcRequest
	DataSourceType string                `position:"Body" name:"DataSourceType"`
	URLList        *[]DetectLymphURLList `position:"Body" name:"URLList"  type:"Repeated"`
	Async          requests.Boolean      `position:"Body" name:"Async"`
}

// DetectLymphURLList is a repeated param struct in DetectLymphRequest
type DetectLymphURLList struct {
	URL string `name:"URL"`
}

// DetectLymphResponse is the response struct for api DetectLymph
type DetectLymphResponse struct {
	*responses.BaseResponse
}

// CreateDetectLymphRequest creates a request to invoke DetectLymph API
func CreateDetectLymphRequest() (request *DetectLymphRequest) {
	request = &DetectLymphRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "DetectLymph", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectLymphResponse creates a response to parse from DetectLymph response
func CreateDetectLymphResponse() (response *DetectLymphResponse) {
	response = &DetectLymphResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
