package imageenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateImageWithText invokes the imageenhan.GenerateImageWithText API synchronously
func (client *Client) GenerateImageWithText(request *GenerateImageWithTextRequest) (response *GenerateImageWithTextResponse, err error) {
	response = CreateGenerateImageWithTextResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateImageWithTextWithChan invokes the imageenhan.GenerateImageWithText API asynchronously
func (client *Client) GenerateImageWithTextWithChan(request *GenerateImageWithTextRequest) (<-chan *GenerateImageWithTextResponse, <-chan error) {
	responseChan := make(chan *GenerateImageWithTextResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateImageWithText(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateImageWithTextWithCallback invokes the imageenhan.GenerateImageWithText API asynchronously
func (client *Client) GenerateImageWithTextWithCallback(request *GenerateImageWithTextRequest, callback func(response *GenerateImageWithTextResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateImageWithTextResponse
		var err error
		defer close(result)
		response, err = client.GenerateImageWithText(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateImageWithTextRequest is the request struct for api GenerateImageWithText
type GenerateImageWithTextRequest struct {
	*requests.RpcRequest
	Resolution string           `position:"Body" name:"Resolution"`
	Number     requests.Integer `position:"Body" name:"Number"`
	Text       string           `position:"Body" name:"Text"`
	Async      requests.Boolean `position:"Body" name:"Async"`
}

// GenerateImageWithTextResponse is the response struct for api GenerateImageWithText
type GenerateImageWithTextResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGenerateImageWithTextRequest creates a request to invoke GenerateImageWithText API
func CreateGenerateImageWithTextRequest() (request *GenerateImageWithTextRequest) {
	request = &GenerateImageWithTextRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageenhan", "2019-09-30", "GenerateImageWithText", "imageenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGenerateImageWithTextResponse creates a response to parse from GenerateImageWithText response
func CreateGenerateImageWithTextResponse() (response *GenerateImageWithTextResponse) {
	response = &GenerateImageWithTextResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
