package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRegionResource invokes the ens.DescribeRegionResource API synchronously
func (client *Client) DescribeRegionResource(request *DescribeRegionResourceRequest) (response *DescribeRegionResourceResponse, err error) {
	response = CreateDescribeRegionResourceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRegionResourceWithChan invokes the ens.DescribeRegionResource API asynchronously
func (client *Client) DescribeRegionResourceWithChan(request *DescribeRegionResourceRequest) (<-chan *DescribeRegionResourceResponse, <-chan error) {
	responseChan := make(chan *DescribeRegionResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRegionResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRegionResourceWithCallback invokes the ens.DescribeRegionResource API asynchronously
func (client *Client) DescribeRegionResourceWithCallback(request *DescribeRegionResourceRequest, callback func(response *DescribeRegionResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRegionResourceResponse
		var err error
		defer close(result)
		response, err = client.DescribeRegionResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRegionResourceRequest is the request struct for api DescribeRegionResource
type DescribeRegionResourceRequest struct {
	*requests.RpcRequest
	IspType      string `position:"Query" name:"IspType"`
	EnsRegionId  string `position:"Query" name:"EnsRegionId"`
	OpenapiCheck string `position:"Query" name:"OpenapiCheck"`
}

// DescribeRegionResourceResponse is the response struct for api DescribeRegionResource
type DescribeRegionResourceResponse struct {
	*responses.BaseResponse
	Msg       string     `json:"Msg" xml:"Msg"`
	Desc      string     `json:"Desc" xml:"Desc"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Pager     Pager      `json:"Pager" xml:"Pager"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeRegionResourceRequest creates a request to invoke DescribeRegionResource API
func CreateDescribeRegionResourceRequest() (request *DescribeRegionResourceRequest) {
	request = &DescribeRegionResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeRegionResource", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeRegionResourceResponse creates a response to parse from DescribeRegionResource response
func CreateDescribeRegionResourceResponse() (response *DescribeRegionResourceResponse) {
	response = &DescribeRegionResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
