package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEnsRouteEntryList invokes the ens.DescribeEnsRouteEntryList API synchronously
func (client *Client) DescribeEnsRouteEntryList(request *DescribeEnsRouteEntryListRequest) (response *DescribeEnsRouteEntryListResponse, err error) {
	response = CreateDescribeEnsRouteEntryListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEnsRouteEntryListWithChan invokes the ens.DescribeEnsRouteEntryList API asynchronously
func (client *Client) DescribeEnsRouteEntryListWithChan(request *DescribeEnsRouteEntryListRequest) (<-chan *DescribeEnsRouteEntryListResponse, <-chan error) {
	responseChan := make(chan *DescribeEnsRouteEntryListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEnsRouteEntryList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEnsRouteEntryListWithCallback invokes the ens.DescribeEnsRouteEntryList API asynchronously
func (client *Client) DescribeEnsRouteEntryListWithCallback(request *DescribeEnsRouteEntryListRequest, callback func(response *DescribeEnsRouteEntryListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEnsRouteEntryListResponse
		var err error
		defer close(result)
		response, err = client.DescribeEnsRouteEntryList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEnsRouteEntryListRequest is the request struct for api DescribeEnsRouteEntryList
type DescribeEnsRouteEntryListRequest struct {
	*requests.RpcRequest
	RouteEntryName       string           `position:"Query" name:"RouteEntryName"`
	NextHopId            string           `position:"Query" name:"NextHopId"`
	NextHopType          string           `position:"Query" name:"NextHopType"`
	RouteTableId         string           `position:"Query" name:"RouteTableId"`
	DestinationCidrBlock string           `position:"Query" name:"DestinationCidrBlock"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	RouteEntryType       string           `position:"Query" name:"RouteEntryType"`
	RouteEntryId         string           `position:"Query" name:"RouteEntryId"`
}

// DescribeEnsRouteEntryListResponse is the response struct for api DescribeEnsRouteEntryList
type DescribeEnsRouteEntryListResponse struct {
	*responses.BaseResponse
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	PageNumber  int          `json:"PageNumber" xml:"PageNumber"`
	PageSize    int          `json:"PageSize" xml:"PageSize"`
	TotalCount  int          `json:"TotalCount" xml:"TotalCount"`
	RouteEntrys []RouteEntry `json:"RouteEntrys" xml:"RouteEntrys"`
}

// CreateDescribeEnsRouteEntryListRequest creates a request to invoke DescribeEnsRouteEntryList API
func CreateDescribeEnsRouteEntryListRequest() (request *DescribeEnsRouteEntryListRequest) {
	request = &DescribeEnsRouteEntryListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeEnsRouteEntryList", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEnsRouteEntryListResponse creates a response to parse from DescribeEnsRouteEntryList response
func CreateDescribeEnsRouteEntryListResponse() (response *DescribeEnsRouteEntryListResponse) {
	response = &DescribeEnsRouteEntryListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
