package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateScalingGroupV2 invokes the emr.CreateScalingGroupV2 API synchronously
func (client *Client) CreateScalingGroupV2(request *CreateScalingGroupV2Request) (response *CreateScalingGroupV2Response, err error) {
	response = CreateCreateScalingGroupV2Response()
	err = client.DoAction(request, response)
	return
}

// CreateScalingGroupV2WithChan invokes the emr.CreateScalingGroupV2 API asynchronously
func (client *Client) CreateScalingGroupV2WithChan(request *CreateScalingGroupV2Request) (<-chan *CreateScalingGroupV2Response, <-chan error) {
	responseChan := make(chan *CreateScalingGroupV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateScalingGroupV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateScalingGroupV2WithCallback invokes the emr.CreateScalingGroupV2 API asynchronously
func (client *Client) CreateScalingGroupV2WithCallback(request *CreateScalingGroupV2Request, callback func(response *CreateScalingGroupV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateScalingGroupV2Response
		var err error
		defer close(result)
		response, err = client.CreateScalingGroupV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateScalingGroupV2Request is the request struct for api CreateScalingGroupV2
type CreateScalingGroupV2Request struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Description     string           `position:"Query" name:"Description"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	HostGroupId     string           `position:"Query" name:"HostGroupId"`
	Name            string           `position:"Query" name:"Name"`
}

// CreateScalingGroupV2Response is the response struct for api CreateScalingGroupV2
type CreateScalingGroupV2Response struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateCreateScalingGroupV2Request creates a request to invoke CreateScalingGroupV2 API
func CreateCreateScalingGroupV2Request() (request *CreateScalingGroupV2Request) {
	request = &CreateScalingGroupV2Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateScalingGroupV2", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateScalingGroupV2Response creates a response to parse from CreateScalingGroupV2 response
func CreateCreateScalingGroupV2Response() (response *CreateScalingGroupV2Response) {
	response = &CreateScalingGroupV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
