package emas_appmonitor

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSdkConfig invokes the emas_appmonitor.GetSdkConfig API synchronously
func (client *Client) GetSdkConfig(request *GetSdkConfigRequest) (response *GetSdkConfigResponse, err error) {
	response = CreateGetSdkConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetSdkConfigWithChan invokes the emas_appmonitor.GetSdkConfig API asynchronously
func (client *Client) GetSdkConfigWithChan(request *GetSdkConfigRequest) (<-chan *GetSdkConfigResponse, <-chan error) {
	responseChan := make(chan *GetSdkConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSdkConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSdkConfigWithCallback invokes the emas_appmonitor.GetSdkConfig API asynchronously
func (client *Client) GetSdkConfigWithCallback(request *GetSdkConfigRequest, callback func(response *GetSdkConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSdkConfigResponse
		var err error
		defer close(result)
		response, err = client.GetSdkConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSdkConfigRequest is the request struct for api GetSdkConfig
type GetSdkConfigRequest struct {
	*requests.RpcRequest
	UniqueAppId string `position:"Body" name:"UniqueAppId"`
}

// GetSdkConfigResponse is the response struct for api GetSdkConfig
type GetSdkConfigResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	SDKConfig map[string]interface{} `json:"SDKConfig" xml:"SDKConfig"`
}

// CreateGetSdkConfigRequest creates a request to invoke GetSdkConfig API
func CreateGetSdkConfigRequest() (request *GetSdkConfigRequest) {
	request = &GetSdkConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("emas-appmonitor", "2019-06-11", "GetSdkConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateGetSdkConfigResponse creates a response to parse from GetSdkConfig response
func CreateGetSdkConfigResponse() (response *GetSdkConfigResponse) {
	response = &GetSdkConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
