package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCommunityImages invokes the ehpc.ListCommunityImages API synchronously
func (client *Client) ListCommunityImages(request *ListCommunityImagesRequest) (response *ListCommunityImagesResponse, err error) {
	response = CreateListCommunityImagesResponse()
	err = client.DoAction(request, response)
	return
}

// ListCommunityImagesWithChan invokes the ehpc.ListCommunityImages API asynchronously
func (client *Client) ListCommunityImagesWithChan(request *ListCommunityImagesRequest) (<-chan *ListCommunityImagesResponse, <-chan error) {
	responseChan := make(chan *ListCommunityImagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCommunityImages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCommunityImagesWithCallback invokes the ehpc.ListCommunityImages API asynchronously
func (client *Client) ListCommunityImagesWithCallback(request *ListCommunityImagesRequest, callback func(response *ListCommunityImagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCommunityImagesResponse
		var err error
		defer close(result)
		response, err = client.ListCommunityImages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCommunityImagesRequest is the request struct for api ListCommunityImages
type ListCommunityImagesRequest struct {
	*requests.RpcRequest
	ClusterId    string `position:"Query" name:"ClusterId"`
	BaseOsTag    string `position:"Query" name:"BaseOsTag"`
	InstanceType string `position:"Query" name:"InstanceType"`
}

// ListCommunityImagesResponse is the response struct for api ListCommunityImages
type ListCommunityImagesResponse struct {
	*responses.BaseResponse
	RequestId string                      `json:"RequestId" xml:"RequestId"`
	Images    ImagesInListCommunityImages `json:"Images" xml:"Images"`
}

// CreateListCommunityImagesRequest creates a request to invoke ListCommunityImages API
func CreateListCommunityImagesRequest() (request *ListCommunityImagesRequest) {
	request = &ListCommunityImagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "ListCommunityImages", "", "")
	request.Method = requests.GET
	return
}

// CreateListCommunityImagesResponse creates a response to parse from ListCommunityImages response
func CreateListCommunityImagesResponse() (response *ListCommunityImagesResponse) {
	response = &ListCommunityImagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
