package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGWSClusterPolicy invokes the ehpc.DescribeGWSClusterPolicy API synchronously
func (client *Client) DescribeGWSClusterPolicy(request *DescribeGWSClusterPolicyRequest) (response *DescribeGWSClusterPolicyResponse, err error) {
	response = CreateDescribeGWSClusterPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGWSClusterPolicyWithChan invokes the ehpc.DescribeGWSClusterPolicy API asynchronously
func (client *Client) DescribeGWSClusterPolicyWithChan(request *DescribeGWSClusterPolicyRequest) (<-chan *DescribeGWSClusterPolicyResponse, <-chan error) {
	responseChan := make(chan *DescribeGWSClusterPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGWSClusterPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGWSClusterPolicyWithCallback invokes the ehpc.DescribeGWSClusterPolicy API asynchronously
func (client *Client) DescribeGWSClusterPolicyWithCallback(request *DescribeGWSClusterPolicyRequest, callback func(response *DescribeGWSClusterPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGWSClusterPolicyResponse
		var err error
		defer close(result)
		response, err = client.DescribeGWSClusterPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGWSClusterPolicyRequest is the request struct for api DescribeGWSClusterPolicy
type DescribeGWSClusterPolicyRequest struct {
	*requests.RpcRequest
	ClusterId string           `position:"Query" name:"ClusterId"`
	AsyncMode requests.Boolean `position:"Query" name:"AsyncMode"`
	TaskId    string           `position:"Query" name:"TaskId"`
}

// DescribeGWSClusterPolicyResponse is the response struct for api DescribeGWSClusterPolicy
type DescribeGWSClusterPolicyResponse struct {
	*responses.BaseResponse
	Watermark   string `json:"Watermark" xml:"Watermark"`
	Clipboard   string `json:"Clipboard" xml:"Clipboard"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	UsbRedirect string `json:"UsbRedirect" xml:"UsbRedirect"`
	LocalDrive  string `json:"LocalDrive" xml:"LocalDrive"`
}

// CreateDescribeGWSClusterPolicyRequest creates a request to invoke DescribeGWSClusterPolicy API
func CreateDescribeGWSClusterPolicyRequest() (request *DescribeGWSClusterPolicyRequest) {
	request = &DescribeGWSClusterPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "DescribeGWSClusterPolicy", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeGWSClusterPolicyResponse creates a response to parse from DescribeGWSClusterPolicy response
func CreateDescribeGWSClusterPolicyResponse() (response *DescribeGWSClusterPolicyResponse) {
	response = &DescribeGWSClusterPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
