package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAutoScaleConfig invokes the ehpc.DescribeAutoScaleConfig API synchronously
func (client *Client) DescribeAutoScaleConfig(request *DescribeAutoScaleConfigRequest) (response *DescribeAutoScaleConfigResponse, err error) {
	response = CreateDescribeAutoScaleConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAutoScaleConfigWithChan invokes the ehpc.DescribeAutoScaleConfig API asynchronously
func (client *Client) DescribeAutoScaleConfigWithChan(request *DescribeAutoScaleConfigRequest) (<-chan *DescribeAutoScaleConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeAutoScaleConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAutoScaleConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAutoScaleConfigWithCallback invokes the ehpc.DescribeAutoScaleConfig API asynchronously
func (client *Client) DescribeAutoScaleConfigWithCallback(request *DescribeAutoScaleConfigRequest, callback func(response *DescribeAutoScaleConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAutoScaleConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeAutoScaleConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAutoScaleConfigRequest is the request struct for api DescribeAutoScaleConfig
type DescribeAutoScaleConfigRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DescribeAutoScaleConfigResponse is the response struct for api DescribeAutoScaleConfig
type DescribeAutoScaleConfigResponse struct {
	*responses.BaseResponse
	MaxNodesInCluster       int    `json:"MaxNodesInCluster" xml:"MaxNodesInCluster"`
	GrowTimeoutInMinutes    int    `json:"GrowTimeoutInMinutes" xml:"GrowTimeoutInMinutes"`
	SpotStrategy            string `json:"SpotStrategy" xml:"SpotStrategy"`
	RequestId               string `json:"RequestId" xml:"RequestId"`
	EnableAutoShrink        bool   `json:"EnableAutoShrink" xml:"EnableAutoShrink"`
	ClusterType             string `json:"ClusterType" xml:"ClusterType"`
	EnableAutoGrow          bool   `json:"EnableAutoGrow" xml:"EnableAutoGrow"`
	ExcludeNodes            string `json:"ExcludeNodes" xml:"ExcludeNodes"`
	GrowIntervalInMinutes   int    `json:"GrowIntervalInMinutes" xml:"GrowIntervalInMinutes"`
	ShrinkIntervalInMinutes int    `json:"ShrinkIntervalInMinutes" xml:"ShrinkIntervalInMinutes"`
	SpotPriceLimit          string `json:"SpotPriceLimit" xml:"SpotPriceLimit"`
	ShrinkIdleTimes         int    `json:"ShrinkIdleTimes" xml:"ShrinkIdleTimes"`
	ExtraNodesGrowRatio     int    `json:"ExtraNodesGrowRatio" xml:"ExtraNodesGrowRatio"`
	GrowRatio               int    `json:"GrowRatio" xml:"GrowRatio"`
	Uid                     string `json:"Uid" xml:"Uid"`
	ClusterId               string `json:"ClusterId" xml:"ClusterId"`
}

// CreateDescribeAutoScaleConfigRequest creates a request to invoke DescribeAutoScaleConfig API
func CreateDescribeAutoScaleConfigRequest() (request *DescribeAutoScaleConfigRequest) {
	request = &DescribeAutoScaleConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "DescribeAutoScaleConfig", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeAutoScaleConfigResponse creates a response to parse from DescribeAutoScaleConfig response
func CreateDescribeAutoScaleConfigResponse() (response *DescribeAutoScaleConfigResponse) {
	response = &DescribeAutoScaleConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
