package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetNASDefaultMountTarget invokes the ecd.ResetNASDefaultMountTarget API synchronously
func (client *Client) ResetNASDefaultMountTarget(request *ResetNASDefaultMountTargetRequest) (response *ResetNASDefaultMountTargetResponse, err error) {
	response = CreateResetNASDefaultMountTargetResponse()
	err = client.DoAction(request, response)
	return
}

// ResetNASDefaultMountTargetWithChan invokes the ecd.ResetNASDefaultMountTarget API asynchronously
func (client *Client) ResetNASDefaultMountTargetWithChan(request *ResetNASDefaultMountTargetRequest) (<-chan *ResetNASDefaultMountTargetResponse, <-chan error) {
	responseChan := make(chan *ResetNASDefaultMountTargetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetNASDefaultMountTarget(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetNASDefaultMountTargetWithCallback invokes the ecd.ResetNASDefaultMountTarget API asynchronously
func (client *Client) ResetNASDefaultMountTargetWithCallback(request *ResetNASDefaultMountTargetRequest, callback func(response *ResetNASDefaultMountTargetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetNASDefaultMountTargetResponse
		var err error
		defer close(result)
		response, err = client.ResetNASDefaultMountTarget(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetNASDefaultMountTargetRequest is the request struct for api ResetNASDefaultMountTarget
type ResetNASDefaultMountTargetRequest struct {
	*requests.RpcRequest
	FileSystemId string `position:"Query" name:"FileSystemId"`
}

// ResetNASDefaultMountTargetResponse is the response struct for api ResetNASDefaultMountTarget
type ResetNASDefaultMountTargetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateResetNASDefaultMountTargetRequest creates a request to invoke ResetNASDefaultMountTarget API
func CreateResetNASDefaultMountTargetRequest() (request *ResetNASDefaultMountTargetRequest) {
	request = &ResetNASDefaultMountTargetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ResetNASDefaultMountTarget", "", "")
	request.Method = requests.POST
	return
}

// CreateResetNASDefaultMountTargetResponse creates a response to parse from ResetNASDefaultMountTarget response
func CreateResetNASDefaultMountTargetResponse() (response *ResetNASDefaultMountTargetResponse) {
	response = &ResetNASDefaultMountTargetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
