package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyNASDefaultMountTarget invokes the ecd.ModifyNASDefaultMountTarget API synchronously
func (client *Client) ModifyNASDefaultMountTarget(request *ModifyNASDefaultMountTargetRequest) (response *ModifyNASDefaultMountTargetResponse, err error) {
	response = CreateModifyNASDefaultMountTargetResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyNASDefaultMountTargetWithChan invokes the ecd.ModifyNASDefaultMountTarget API asynchronously
func (client *Client) ModifyNASDefaultMountTargetWithChan(request *ModifyNASDefaultMountTargetRequest) (<-chan *ModifyNASDefaultMountTargetResponse, <-chan error) {
	responseChan := make(chan *ModifyNASDefaultMountTargetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyNASDefaultMountTarget(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyNASDefaultMountTargetWithCallback invokes the ecd.ModifyNASDefaultMountTarget API asynchronously
func (client *Client) ModifyNASDefaultMountTargetWithCallback(request *ModifyNASDefaultMountTargetRequest, callback func(response *ModifyNASDefaultMountTargetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyNASDefaultMountTargetResponse
		var err error
		defer close(result)
		response, err = client.ModifyNASDefaultMountTarget(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyNASDefaultMountTargetRequest is the request struct for api ModifyNASDefaultMountTarget
type ModifyNASDefaultMountTargetRequest struct {
	*requests.RpcRequest
	MountTargetDomain string `position:"Query" name:"MountTargetDomain"`
	FileSystemId      string `position:"Query" name:"FileSystemId"`
}

// ModifyNASDefaultMountTargetResponse is the response struct for api ModifyNASDefaultMountTarget
type ModifyNASDefaultMountTargetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyNASDefaultMountTargetRequest creates a request to invoke ModifyNASDefaultMountTarget API
func CreateModifyNASDefaultMountTargetRequest() (request *ModifyNASDefaultMountTargetRequest) {
	request = &ModifyNASDefaultMountTargetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyNASDefaultMountTarget", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyNASDefaultMountTargetResponse creates a response to parse from ModifyNASDefaultMountTarget response
func CreateModifyNASDefaultMountTargetResponse() (response *ModifyNASDefaultMountTargetResponse) {
	response = &ModifyNASDefaultMountTargetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
