package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSuspEventQuaraFiles invokes the ecd.DescribeSuspEventQuaraFiles API synchronously
func (client *Client) DescribeSuspEventQuaraFiles(request *DescribeSuspEventQuaraFilesRequest) (response *DescribeSuspEventQuaraFilesResponse, err error) {
	response = CreateDescribeSuspEventQuaraFilesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSuspEventQuaraFilesWithChan invokes the ecd.DescribeSuspEventQuaraFiles API asynchronously
func (client *Client) DescribeSuspEventQuaraFilesWithChan(request *DescribeSuspEventQuaraFilesRequest) (<-chan *DescribeSuspEventQuaraFilesResponse, <-chan error) {
	responseChan := make(chan *DescribeSuspEventQuaraFilesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSuspEventQuaraFiles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSuspEventQuaraFilesWithCallback invokes the ecd.DescribeSuspEventQuaraFiles API asynchronously
func (client *Client) DescribeSuspEventQuaraFilesWithCallback(request *DescribeSuspEventQuaraFilesRequest, callback func(response *DescribeSuspEventQuaraFilesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSuspEventQuaraFilesResponse
		var err error
		defer close(result)
		response, err = client.DescribeSuspEventQuaraFiles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSuspEventQuaraFilesRequest is the request struct for api DescribeSuspEventQuaraFiles
type DescribeSuspEventQuaraFilesRequest struct {
	*requests.RpcRequest
	OfficeSiteId string           `position:"Query" name:"OfficeSiteId"`
	CurrentPage  requests.Integer `position:"Query" name:"CurrentPage"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	Status       string           `position:"Query" name:"Status"`
}

// DescribeSuspEventQuaraFilesResponse is the response struct for api DescribeSuspEventQuaraFiles
type DescribeSuspEventQuaraFilesResponse struct {
	*responses.BaseResponse
	CurrentPage int         `json:"CurrentPage" xml:"CurrentPage"`
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	PageSize    int         `json:"PageSize" xml:"PageSize"`
	TotalCount  int         `json:"TotalCount" xml:"TotalCount"`
	QuaraFiles  []QuaraFile `json:"QuaraFiles" xml:"QuaraFiles"`
}

// CreateDescribeSuspEventQuaraFilesRequest creates a request to invoke DescribeSuspEventQuaraFiles API
func CreateDescribeSuspEventQuaraFilesRequest() (request *DescribeSuspEventQuaraFilesRequest) {
	request = &DescribeSuspEventQuaraFilesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeSuspEventQuaraFiles", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSuspEventQuaraFilesResponse creates a response to parse from DescribeSuspEventQuaraFiles response
func CreateDescribeSuspEventQuaraFilesResponse() (response *DescribeSuspEventQuaraFilesResponse) {
	response = &DescribeSuspEventQuaraFilesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
