package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDesktopIdsByVulNames invokes the ecd.DescribeDesktopIdsByVulNames API synchronously
func (client *Client) DescribeDesktopIdsByVulNames(request *DescribeDesktopIdsByVulNamesRequest) (response *DescribeDesktopIdsByVulNamesResponse, err error) {
	response = CreateDescribeDesktopIdsByVulNamesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDesktopIdsByVulNamesWithChan invokes the ecd.DescribeDesktopIdsByVulNames API asynchronously
func (client *Client) DescribeDesktopIdsByVulNamesWithChan(request *DescribeDesktopIdsByVulNamesRequest) (<-chan *DescribeDesktopIdsByVulNamesResponse, <-chan error) {
	responseChan := make(chan *DescribeDesktopIdsByVulNamesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDesktopIdsByVulNames(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDesktopIdsByVulNamesWithCallback invokes the ecd.DescribeDesktopIdsByVulNames API asynchronously
func (client *Client) DescribeDesktopIdsByVulNamesWithCallback(request *DescribeDesktopIdsByVulNamesRequest, callback func(response *DescribeDesktopIdsByVulNamesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDesktopIdsByVulNamesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDesktopIdsByVulNames(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDesktopIdsByVulNamesRequest is the request struct for api DescribeDesktopIdsByVulNames
type DescribeDesktopIdsByVulNamesRequest struct {
	*requests.RpcRequest
	OfficeSiteId string    `position:"Query" name:"OfficeSiteId"`
	Type         string    `position:"Query" name:"Type"`
	VulName      *[]string `position:"Query" name:"VulName"  type:"Repeated"`
	Necessity    string    `position:"Query" name:"Necessity"`
}

// DescribeDesktopIdsByVulNamesResponse is the response struct for api DescribeDesktopIdsByVulNames
type DescribeDesktopIdsByVulNamesResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	DesktopItems []DesktopItem `json:"DesktopItems" xml:"DesktopItems"`
}

// CreateDescribeDesktopIdsByVulNamesRequest creates a request to invoke DescribeDesktopIdsByVulNames API
func CreateDescribeDesktopIdsByVulNamesRequest() (request *DescribeDesktopIdsByVulNamesRequest) {
	request = &DescribeDesktopIdsByVulNamesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeDesktopIdsByVulNames", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDesktopIdsByVulNamesResponse creates a response to parse from DescribeDesktopIdsByVulNames response
func CreateDescribeDesktopIdsByVulNamesResponse() (response *DescribeDesktopIdsByVulNamesResponse) {
	response = &DescribeDesktopIdsByVulNamesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
