package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigADConnectorTrust invokes the ecd.ConfigADConnectorTrust API synchronously
func (client *Client) ConfigADConnectorTrust(request *ConfigADConnectorTrustRequest) (response *ConfigADConnectorTrustResponse, err error) {
	response = CreateConfigADConnectorTrustResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigADConnectorTrustWithChan invokes the ecd.ConfigADConnectorTrust API asynchronously
func (client *Client) ConfigADConnectorTrustWithChan(request *ConfigADConnectorTrustRequest) (<-chan *ConfigADConnectorTrustResponse, <-chan error) {
	responseChan := make(chan *ConfigADConnectorTrustResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigADConnectorTrust(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigADConnectorTrustWithCallback invokes the ecd.ConfigADConnectorTrust API asynchronously
func (client *Client) ConfigADConnectorTrustWithCallback(request *ConfigADConnectorTrustRequest, callback func(response *ConfigADConnectorTrustResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigADConnectorTrustResponse
		var err error
		defer close(result)
		response, err = client.ConfigADConnectorTrust(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigADConnectorTrustRequest is the request struct for api ConfigADConnectorTrust
type ConfigADConnectorTrustRequest struct {
	*requests.RpcRequest
	OfficeSiteId string `position:"Query" name:"OfficeSiteId"`
	TrustKey     string `position:"Query" name:"TrustKey"`
}

// ConfigADConnectorTrustResponse is the response struct for api ConfigADConnectorTrust
type ConfigADConnectorTrustResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConfigADConnectorTrustRequest creates a request to invoke ConfigADConnectorTrust API
func CreateConfigADConnectorTrustRequest() (request *ConfigADConnectorTrustRequest) {
	request = &ConfigADConnectorTrustRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ConfigADConnectorTrust", "", "")
	request.Method = requests.POST
	return
}

// CreateConfigADConnectorTrustResponse creates a response to parse from ConfigADConnectorTrust response
func CreateConfigADConnectorTrustResponse() (response *ConfigADConnectorTrustResponse) {
	response = &ConfigADConnectorTrustResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
