package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddUserToDesktopGroup invokes the ecd.AddUserToDesktopGroup API synchronously
func (client *Client) AddUserToDesktopGroup(request *AddUserToDesktopGroupRequest) (response *AddUserToDesktopGroupResponse, err error) {
	response = CreateAddUserToDesktopGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AddUserToDesktopGroupWithChan invokes the ecd.AddUserToDesktopGroup API asynchronously
func (client *Client) AddUserToDesktopGroupWithChan(request *AddUserToDesktopGroupRequest) (<-chan *AddUserToDesktopGroupResponse, <-chan error) {
	responseChan := make(chan *AddUserToDesktopGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddUserToDesktopGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddUserToDesktopGroupWithCallback invokes the ecd.AddUserToDesktopGroup API asynchronously
func (client *Client) AddUserToDesktopGroupWithCallback(request *AddUserToDesktopGroupRequest, callback func(response *AddUserToDesktopGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddUserToDesktopGroupResponse
		var err error
		defer close(result)
		response, err = client.AddUserToDesktopGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddUserToDesktopGroupRequest is the request struct for api AddUserToDesktopGroup
type AddUserToDesktopGroupRequest struct {
	*requests.RpcRequest
	EndUserIds      *[]string `position:"Query" name:"EndUserIds"  type:"Repeated"`
	ClientToken     string    `position:"Query" name:"ClientToken"`
	DesktopGroupId  string    `position:"Query" name:"DesktopGroupId"`
	DesktopGroupIds *[]string `position:"Query" name:"DesktopGroupIds"  type:"Repeated"`
}

// AddUserToDesktopGroupResponse is the response struct for api AddUserToDesktopGroup
type AddUserToDesktopGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddUserToDesktopGroupRequest creates a request to invoke AddUserToDesktopGroup API
func CreateAddUserToDesktopGroupRequest() (request *AddUserToDesktopGroupRequest) {
	request = &AddUserToDesktopGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "AddUserToDesktopGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateAddUserToDesktopGroupResponse creates a response to parse from AddUserToDesktopGroup response
func CreateAddUserToDesktopGroupResponse() (response *AddUserToDesktopGroupResponse) {
	response = &AddUserToDesktopGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
