package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOrderedNumbers invokes the dyvmsapi.ListOrderedNumbers API synchronously
func (client *Client) ListOrderedNumbers(request *ListOrderedNumbersRequest) (response *ListOrderedNumbersResponse, err error) {
	response = CreateListOrderedNumbersResponse()
	err = client.DoAction(request, response)
	return
}

// ListOrderedNumbersWithChan invokes the dyvmsapi.ListOrderedNumbers API asynchronously
func (client *Client) ListOrderedNumbersWithChan(request *ListOrderedNumbersRequest) (<-chan *ListOrderedNumbersResponse, <-chan error) {
	responseChan := make(chan *ListOrderedNumbersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOrderedNumbers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOrderedNumbersWithCallback invokes the dyvmsapi.ListOrderedNumbers API asynchronously
func (client *Client) ListOrderedNumbersWithCallback(request *ListOrderedNumbersRequest, callback func(response *ListOrderedNumbersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOrderedNumbersResponse
		var err error
		defer close(result)
		response, err = client.ListOrderedNumbers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOrderedNumbersRequest is the request struct for api ListOrderedNumbers
type ListOrderedNumbersRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProdCode             string           `position:"Query" name:"ProdCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ListOrderedNumbersResponse is the response struct for api ListOrderedNumbers
type ListOrderedNumbersResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Code      string   `json:"Code" xml:"Code"`
	Message   string   `json:"Message" xml:"Message"`
	Numbers   []string `json:"Numbers" xml:"Numbers"`
}

// CreateListOrderedNumbersRequest creates a request to invoke ListOrderedNumbers API
func CreateListOrderedNumbersRequest() (request *ListOrderedNumbersRequest) {
	request = &ListOrderedNumbersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "ListOrderedNumbers", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListOrderedNumbersResponse creates a response to parse from ListOrderedNumbers response
func CreateListOrderedNumbersResponse() (response *ListOrderedNumbersResponse) {
	response = &ListOrderedNumbersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
