package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwitchPhysicalDtsJobToCloud invokes the dts.SwitchPhysicalDtsJobToCloud API synchronously
func (client *Client) SwitchPhysicalDtsJobToCloud(request *SwitchPhysicalDtsJobToCloudRequest) (response *SwitchPhysicalDtsJobToCloudResponse, err error) {
	response = CreateSwitchPhysicalDtsJobToCloudResponse()
	err = client.DoAction(request, response)
	return
}

// SwitchPhysicalDtsJobToCloudWithChan invokes the dts.SwitchPhysicalDtsJobToCloud API asynchronously
func (client *Client) SwitchPhysicalDtsJobToCloudWithChan(request *SwitchPhysicalDtsJobToCloudRequest) (<-chan *SwitchPhysicalDtsJobToCloudResponse, <-chan error) {
	responseChan := make(chan *SwitchPhysicalDtsJobToCloudResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwitchPhysicalDtsJobToCloud(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwitchPhysicalDtsJobToCloudWithCallback invokes the dts.SwitchPhysicalDtsJobToCloud API asynchronously
func (client *Client) SwitchPhysicalDtsJobToCloudWithCallback(request *SwitchPhysicalDtsJobToCloudRequest, callback func(response *SwitchPhysicalDtsJobToCloudResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwitchPhysicalDtsJobToCloudResponse
		var err error
		defer close(result)
		response, err = client.SwitchPhysicalDtsJobToCloud(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwitchPhysicalDtsJobToCloudRequest is the request struct for api SwitchPhysicalDtsJobToCloud
type SwitchPhysicalDtsJobToCloudRequest struct {
	*requests.RpcRequest
	ResetCheckpoint          string `position:"Query" name:"ResetCheckpoint"`
	ResumeHoldJob            string `position:"Query" name:"ResumeHoldJob"`
	DtsJobId                 string `position:"Query" name:"DtsJobId"`
	DtsInstanceId            string `position:"Query" name:"DtsInstanceId"`
	SynchronizationDirection string `position:"Query" name:"SynchronizationDirection"`
}

// SwitchPhysicalDtsJobToCloudResponse is the response struct for api SwitchPhysicalDtsJobToCloud
type SwitchPhysicalDtsJobToCloudResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
}

// CreateSwitchPhysicalDtsJobToCloudRequest creates a request to invoke SwitchPhysicalDtsJobToCloud API
func CreateSwitchPhysicalDtsJobToCloudRequest() (request *SwitchPhysicalDtsJobToCloudRequest) {
	request = &SwitchPhysicalDtsJobToCloudRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "SwitchPhysicalDtsJobToCloud", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSwitchPhysicalDtsJobToCloudResponse creates a response to parse from SwitchPhysicalDtsJobToCloud response
func CreateSwitchPhysicalDtsJobToCloudResponse() (response *SwitchPhysicalDtsJobToCloudResponse) {
	response = &SwitchPhysicalDtsJobToCloudResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
