package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDtsJobDuLimit invokes the dts.ModifyDtsJobDuLimit API synchronously
func (client *Client) ModifyDtsJobDuLimit(request *ModifyDtsJobDuLimitRequest) (response *ModifyDtsJobDuLimitResponse, err error) {
	response = CreateModifyDtsJobDuLimitResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDtsJobDuLimitWithChan invokes the dts.ModifyDtsJobDuLimit API asynchronously
func (client *Client) ModifyDtsJobDuLimitWithChan(request *ModifyDtsJobDuLimitRequest) (<-chan *ModifyDtsJobDuLimitResponse, <-chan error) {
	responseChan := make(chan *ModifyDtsJobDuLimitResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDtsJobDuLimit(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDtsJobDuLimitWithCallback invokes the dts.ModifyDtsJobDuLimit API asynchronously
func (client *Client) ModifyDtsJobDuLimitWithCallback(request *ModifyDtsJobDuLimitRequest, callback func(response *ModifyDtsJobDuLimitResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDtsJobDuLimitResponse
		var err error
		defer close(result)
		response, err = client.ModifyDtsJobDuLimit(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDtsJobDuLimitRequest is the request struct for api ModifyDtsJobDuLimit
type ModifyDtsJobDuLimitRequest struct {
	*requests.RpcRequest
	OwnerId  string           `position:"Query" name:"OwnerId"`
	DuLimit  requests.Integer `position:"Query" name:"DuLimit"`
	DtsJobId string           `position:"Query" name:"DtsJobId"`
}

// ModifyDtsJobDuLimitResponse is the response struct for api ModifyDtsJobDuLimit
type ModifyDtsJobDuLimitResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
}

// CreateModifyDtsJobDuLimitRequest creates a request to invoke ModifyDtsJobDuLimit API
func CreateModifyDtsJobDuLimitRequest() (request *ModifyDtsJobDuLimitRequest) {
	request = &ModifyDtsJobDuLimitRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "ModifyDtsJobDuLimit", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDtsJobDuLimitResponse creates a response to parse from ModifyDtsJobDuLimit response
func CreateModifyDtsJobDuLimitResponse() (response *ModifyDtsJobDuLimitResponse) {
	response = &ModifyDtsJobDuLimitResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
