package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCheckJobs invokes the dts.DescribeCheckJobs API synchronously
func (client *Client) DescribeCheckJobs(request *DescribeCheckJobsRequest) (response *DescribeCheckJobsResponse, err error) {
	response = CreateDescribeCheckJobsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCheckJobsWithChan invokes the dts.DescribeCheckJobs API asynchronously
func (client *Client) DescribeCheckJobsWithChan(request *DescribeCheckJobsRequest) (<-chan *DescribeCheckJobsResponse, <-chan error) {
	responseChan := make(chan *DescribeCheckJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCheckJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCheckJobsWithCallback invokes the dts.DescribeCheckJobs API asynchronously
func (client *Client) DescribeCheckJobsWithCallback(request *DescribeCheckJobsRequest, callback func(response *DescribeCheckJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCheckJobsResponse
		var err error
		defer close(result)
		response, err = client.DescribeCheckJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCheckJobsRequest is the request struct for api DescribeCheckJobs
type DescribeCheckJobsRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	CheckType  requests.Integer `position:"Query" name:"CheckType"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	JobName    string           `position:"Query" name:"JobName"`
}

// DescribeCheckJobsResponse is the response struct for api DescribeCheckJobs
type DescribeCheckJobsResponse struct {
	*responses.BaseResponse
	HttpStatusCode   int             `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId        string          `json:"RequestId" xml:"RequestId"`
	ErrCode          string          `json:"ErrCode" xml:"ErrCode"`
	Success          bool            `json:"Success" xml:"Success"`
	DynamicCode      string          `json:"DynamicCode" xml:"DynamicCode"`
	ErrMessage       string          `json:"ErrMessage" xml:"ErrMessage"`
	DynamicMessage   string          `json:"DynamicMessage" xml:"DynamicMessage"`
	PageNumber       int             `json:"PageNumber" xml:"PageNumber"`
	PageRecordCount  int64           `json:"PageRecordCount" xml:"PageRecordCount"`
	TotalRecordCount int64           `json:"TotalRecordCount" xml:"TotalRecordCount"`
	CheckJobs        []CheckJobsItem `json:"CheckJobs" xml:"CheckJobs"`
}

// CreateDescribeCheckJobsRequest creates a request to invoke DescribeCheckJobs API
func CreateDescribeCheckJobsRequest() (request *DescribeCheckJobsRequest) {
	request = &DescribeCheckJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeCheckJobs", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCheckJobsResponse creates a response to parse from DescribeCheckJobs response
func CreateDescribeCheckJobsResponse() (response *DescribeCheckJobsResponse) {
	response = &DescribeCheckJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
