package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDataCronClearConfig invokes the dms_enterprise.GetDataCronClearConfig API synchronously
func (client *Client) GetDataCronClearConfig(request *GetDataCronClearConfigRequest) (response *GetDataCronClearConfigResponse, err error) {
	response = CreateGetDataCronClearConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetDataCronClearConfigWithChan invokes the dms_enterprise.GetDataCronClearConfig API asynchronously
func (client *Client) GetDataCronClearConfigWithChan(request *GetDataCronClearConfigRequest) (<-chan *GetDataCronClearConfigResponse, <-chan error) {
	responseChan := make(chan *GetDataCronClearConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDataCronClearConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDataCronClearConfigWithCallback invokes the dms_enterprise.GetDataCronClearConfig API asynchronously
func (client *Client) GetDataCronClearConfigWithCallback(request *GetDataCronClearConfigRequest, callback func(response *GetDataCronClearConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDataCronClearConfigResponse
		var err error
		defer close(result)
		response, err = client.GetDataCronClearConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDataCronClearConfigRequest is the request struct for api GetDataCronClearConfig
type GetDataCronClearConfigRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	OrderId requests.Integer `position:"Query" name:"OrderId"`
}

// GetDataCronClearConfigResponse is the response struct for api GetDataCronClearConfig
type GetDataCronClearConfigResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	Success             bool                `json:"Success" xml:"Success"`
	ErrorMessage        string              `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode           string              `json:"ErrorCode" xml:"ErrorCode"`
	DataCronClearConfig DataCronClearConfig `json:"DataCronClearConfig" xml:"DataCronClearConfig"`
}

// CreateGetDataCronClearConfigRequest creates a request to invoke GetDataCronClearConfig API
func CreateGetDataCronClearConfigRequest() (request *GetDataCronClearConfigRequest) {
	request = &GetDataCronClearConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetDataCronClearConfig", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDataCronClearConfigResponse creates a response to parse from GetDataCronClearConfig response
func CreateGetDataCronClearConfigResponse() (response *GetDataCronClearConfigResponse) {
	response = &GetDataCronClearConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
