package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTaskFlow invokes the dms_enterprise.DeleteTaskFlow API synchronously
func (client *Client) DeleteTaskFlow(request *DeleteTaskFlowRequest) (response *DeleteTaskFlowResponse, err error) {
	response = CreateDeleteTaskFlowResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTaskFlowWithChan invokes the dms_enterprise.DeleteTaskFlow API asynchronously
func (client *Client) DeleteTaskFlowWithChan(request *DeleteTaskFlowRequest) (<-chan *DeleteTaskFlowResponse, <-chan error) {
	responseChan := make(chan *DeleteTaskFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTaskFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTaskFlowWithCallback invokes the dms_enterprise.DeleteTaskFlow API asynchronously
func (client *Client) DeleteTaskFlowWithCallback(request *DeleteTaskFlowRequest, callback func(response *DeleteTaskFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTaskFlowResponse
		var err error
		defer close(result)
		response, err = client.DeleteTaskFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTaskFlowRequest is the request struct for api DeleteTaskFlow
type DeleteTaskFlowRequest struct {
	*requests.RpcRequest
	DagId requests.Integer `position:"Query" name:"DagId"`
	Tid   requests.Integer `position:"Query" name:"Tid"`
}

// DeleteTaskFlowResponse is the response struct for api DeleteTaskFlow
type DeleteTaskFlowResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateDeleteTaskFlowRequest creates a request to invoke DeleteTaskFlow API
func CreateDeleteTaskFlowRequest() (request *DeleteTaskFlowRequest) {
	request = &DeleteTaskFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "DeleteTaskFlow", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteTaskFlowResponse creates a response to parse from DeleteTaskFlow response
func CreateDeleteTaskFlowResponse() (response *DeleteTaskFlowResponse) {
	response = &DeleteTaskFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
