package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSmartGroup invokes the devops_rdc.ListSmartGroup API synchronously
func (client *Client) ListSmartGroup(request *ListSmartGroupRequest) (response *ListSmartGroupResponse, err error) {
	response = CreateListSmartGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ListSmartGroupWithChan invokes the devops_rdc.ListSmartGroup API asynchronously
func (client *Client) ListSmartGroupWithChan(request *ListSmartGroupRequest) (<-chan *ListSmartGroupResponse, <-chan error) {
	responseChan := make(chan *ListSmartGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSmartGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSmartGroupWithCallback invokes the devops_rdc.ListSmartGroup API asynchronously
func (client *Client) ListSmartGroupWithCallback(request *ListSmartGroupRequest, callback func(response *ListSmartGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSmartGroupResponse
		var err error
		defer close(result)
		response, err = client.ListSmartGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSmartGroupRequest is the request struct for api ListSmartGroup
type ListSmartGroupRequest struct {
	*requests.RpcRequest
	ProjectId string `position:"Body" name:"ProjectId"`
	OrgId     string `position:"Body" name:"OrgId"`
}

// ListSmartGroupResponse is the response struct for api ListSmartGroup
type ListSmartGroupResponse struct {
	*responses.BaseResponse
	Successful bool         `json:"Successful" xml:"Successful"`
	ErrorCode  string       `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string       `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string       `json:"RequestId" xml:"RequestId"`
	Object     []SmartGroup `json:"Object" xml:"Object"`
}

// CreateListSmartGroupRequest creates a request to invoke ListSmartGroup API
func CreateListSmartGroupRequest() (request *ListSmartGroupRequest) {
	request = &ListSmartGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "ListSmartGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateListSmartGroupResponse creates a response to parse from ListSmartGroup response
func CreateListSmartGroupResponse() (response *ListSmartGroupResponse) {
	response = &ListSmartGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
