package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyWebIpSetSwitch invokes the ddoscoo.ModifyWebIpSetSwitch API synchronously
func (client *Client) ModifyWebIpSetSwitch(request *ModifyWebIpSetSwitchRequest) (response *ModifyWebIpSetSwitchResponse, err error) {
	response = CreateModifyWebIpSetSwitchResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyWebIpSetSwitchWithChan invokes the ddoscoo.ModifyWebIpSetSwitch API asynchronously
func (client *Client) ModifyWebIpSetSwitchWithChan(request *ModifyWebIpSetSwitchRequest) (<-chan *ModifyWebIpSetSwitchResponse, <-chan error) {
	responseChan := make(chan *ModifyWebIpSetSwitchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyWebIpSetSwitch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyWebIpSetSwitchWithCallback invokes the ddoscoo.ModifyWebIpSetSwitch API asynchronously
func (client *Client) ModifyWebIpSetSwitchWithCallback(request *ModifyWebIpSetSwitchRequest, callback func(response *ModifyWebIpSetSwitchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyWebIpSetSwitchResponse
		var err error
		defer close(result)
		response, err = client.ModifyWebIpSetSwitch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyWebIpSetSwitchRequest is the request struct for api ModifyWebIpSetSwitch
type ModifyWebIpSetSwitchRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
	Config          string `position:"Query" name:"Config"`
}

// ModifyWebIpSetSwitchResponse is the response struct for api ModifyWebIpSetSwitch
type ModifyWebIpSetSwitchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyWebIpSetSwitchRequest creates a request to invoke ModifyWebIpSetSwitch API
func CreateModifyWebIpSetSwitchRequest() (request *ModifyWebIpSetSwitchRequest) {
	request = &ModifyWebIpSetSwitchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyWebIpSetSwitch", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyWebIpSetSwitchResponse creates a response to parse from ModifyWebIpSetSwitch response
func CreateModifyWebIpSetSwitchResponse() (response *ModifyWebIpSetSwitchResponse) {
	response = &ModifyWebIpSetSwitchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
