package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyWebAIProtectMode invokes the ddoscoo.ModifyWebAIProtectMode API synchronously
func (client *Client) ModifyWebAIProtectMode(request *ModifyWebAIProtectModeRequest) (response *ModifyWebAIProtectModeResponse, err error) {
	response = CreateModifyWebAIProtectModeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyWebAIProtectModeWithChan invokes the ddoscoo.ModifyWebAIProtectMode API asynchronously
func (client *Client) ModifyWebAIProtectModeWithChan(request *ModifyWebAIProtectModeRequest) (<-chan *ModifyWebAIProtectModeResponse, <-chan error) {
	responseChan := make(chan *ModifyWebAIProtectModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyWebAIProtectMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyWebAIProtectModeWithCallback invokes the ddoscoo.ModifyWebAIProtectMode API asynchronously
func (client *Client) ModifyWebAIProtectModeWithCallback(request *ModifyWebAIProtectModeRequest, callback func(response *ModifyWebAIProtectModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyWebAIProtectModeResponse
		var err error
		defer close(result)
		response, err = client.ModifyWebAIProtectMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyWebAIProtectModeRequest is the request struct for api ModifyWebAIProtectMode
type ModifyWebAIProtectModeRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
	Config          string `position:"Query" name:"Config"`
}

// ModifyWebAIProtectModeResponse is the response struct for api ModifyWebAIProtectMode
type ModifyWebAIProtectModeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyWebAIProtectModeRequest creates a request to invoke ModifyWebAIProtectMode API
func CreateModifyWebAIProtectModeRequest() (request *ModifyWebAIProtectModeRequest) {
	request = &ModifyWebAIProtectModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyWebAIProtectMode", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyWebAIProtectModeResponse creates a response to parse from ModifyWebAIProtectMode response
func CreateModifyWebAIProtectModeResponse() (response *ModifyWebAIProtectModeResponse) {
	response = &ModifyWebAIProtectModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
