package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainResource invokes the ddoscoo.DescribeDomainResource API synchronously
func (client *Client) DescribeDomainResource(request *DescribeDomainResourceRequest) (response *DescribeDomainResourceResponse, err error) {
	response = CreateDescribeDomainResourceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainResourceWithChan invokes the ddoscoo.DescribeDomainResource API asynchronously
func (client *Client) DescribeDomainResourceWithChan(request *DescribeDomainResourceRequest) (<-chan *DescribeDomainResourceResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainResourceWithCallback invokes the ddoscoo.DescribeDomainResource API asynchronously
func (client *Client) DescribeDomainResourceWithCallback(request *DescribeDomainResourceRequest, callback func(response *DescribeDomainResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainResourceResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainResourceRequest is the request struct for api DescribeDomainResource
type DescribeDomainResourceRequest struct {
	*requests.RpcRequest
	PageNumber         requests.Integer `position:"Query" name:"PageNumber"`
	SourceIp           string           `position:"Query" name:"SourceIp"`
	PageSize           requests.Integer `position:"Query" name:"PageSize"`
	InstanceIds        *[]string        `position:"Query" name:"InstanceIds"  type:"Repeated"`
	QueryDomainPattern string           `position:"Query" name:"QueryDomainPattern"`
	Domain             string           `position:"Query" name:"Domain"`
}

// DescribeDomainResourceResponse is the response struct for api DescribeDomainResource
type DescribeDomainResourceResponse struct {
	*responses.BaseResponse
	TotalCount int64     `json:"TotalCount" xml:"TotalCount"`
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	WebRules   []WebRule `json:"WebRules" xml:"WebRules"`
}

// CreateDescribeDomainResourceRequest creates a request to invoke DescribeDomainResource API
func CreateDescribeDomainResourceRequest() (request *DescribeDomainResourceRequest) {
	request = &DescribeDomainResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeDomainResource", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainResourceResponse creates a response to parse from DescribeDomainResource response
func CreateDescribeDomainResourceResponse() (response *DescribeDomainResourceResponse) {
	response = &DescribeDomainResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
