package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainQPSList invokes the ddoscoo.DescribeDomainQPSList API synchronously
func (client *Client) DescribeDomainQPSList(request *DescribeDomainQPSListRequest) (response *DescribeDomainQPSListResponse, err error) {
	response = CreateDescribeDomainQPSListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainQPSListWithChan invokes the ddoscoo.DescribeDomainQPSList API asynchronously
func (client *Client) DescribeDomainQPSListWithChan(request *DescribeDomainQPSListRequest) (<-chan *DescribeDomainQPSListResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainQPSListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainQPSList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainQPSListWithCallback invokes the ddoscoo.DescribeDomainQPSList API asynchronously
func (client *Client) DescribeDomainQPSListWithCallback(request *DescribeDomainQPSListRequest, callback func(response *DescribeDomainQPSListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainQPSListResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainQPSList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainQPSListRequest is the request struct for api DescribeDomainQPSList
type DescribeDomainQPSListRequest struct {
	*requests.RpcRequest
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	Domain          string           `position:"Query" name:"Domain"`
	Interval        requests.Integer `position:"Query" name:"Interval"`
}

// DescribeDomainQPSListResponse is the response struct for api DescribeDomainQPSList
type DescribeDomainQPSListResponse struct {
	*responses.BaseResponse
	RequestId     string      `json:"RequestId" xml:"RequestId"`
	DomainQPSList []DomainQPS `json:"DomainQPSList" xml:"DomainQPSList"`
}

// CreateDescribeDomainQPSListRequest creates a request to invoke DescribeDomainQPSList API
func CreateDescribeDomainQPSListRequest() (request *DescribeDomainQPSListRequest) {
	request = &DescribeDomainQPSListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeDomainQPSList", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainQPSListResponse creates a response to parse from DescribeDomainQPSList response
func CreateDescribeDomainQPSListResponse() (response *DescribeDomainQPSListResponse) {
	response = &DescribeDomainQPSListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
