package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TagDcdnResources invokes the dcdn.TagDcdnResources API synchronously
func (client *Client) TagDcdnResources(request *TagDcdnResourcesRequest) (response *TagDcdnResourcesResponse, err error) {
	response = CreateTagDcdnResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// TagDcdnResourcesWithChan invokes the dcdn.TagDcdnResources API asynchronously
func (client *Client) TagDcdnResourcesWithChan(request *TagDcdnResourcesRequest) (<-chan *TagDcdnResourcesResponse, <-chan error) {
	responseChan := make(chan *TagDcdnResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TagDcdnResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TagDcdnResourcesWithCallback invokes the dcdn.TagDcdnResources API asynchronously
func (client *Client) TagDcdnResourcesWithCallback(request *TagDcdnResourcesRequest, callback func(response *TagDcdnResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TagDcdnResourcesResponse
		var err error
		defer close(result)
		response, err = client.TagDcdnResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TagDcdnResourcesRequest is the request struct for api TagDcdnResources
type TagDcdnResourcesRequest struct {
	*requests.RpcRequest
	ResourceId   *[]string              `position:"Query" name:"ResourceId"  type:"Repeated"`
	Tag          *[]TagDcdnResourcesTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceType string                 `position:"Query" name:"ResourceType"`
}

// TagDcdnResourcesTag is a repeated param struct in TagDcdnResourcesRequest
type TagDcdnResourcesTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// TagDcdnResourcesResponse is the response struct for api TagDcdnResources
type TagDcdnResourcesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateTagDcdnResourcesRequest creates a request to invoke TagDcdnResources API
func CreateTagDcdnResourcesRequest() (request *TagDcdnResourcesRequest) {
	request = &TagDcdnResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "TagDcdnResources", "", "")
	request.Method = requests.POST
	return
}

// CreateTagDcdnResourcesResponse creates a response to parse from TagDcdnResources response
func CreateTagDcdnResourcesResponse() (response *TagDcdnResourcesResponse) {
	response = &TagDcdnResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
