package dbs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartBackupPlan invokes the dbs.StartBackupPlan API synchronously
func (client *Client) StartBackupPlan(request *StartBackupPlanRequest) (response *StartBackupPlanResponse, err error) {
	response = CreateStartBackupPlanResponse()
	err = client.DoAction(request, response)
	return
}

// StartBackupPlanWithChan invokes the dbs.StartBackupPlan API asynchronously
func (client *Client) StartBackupPlanWithChan(request *StartBackupPlanRequest) (<-chan *StartBackupPlanResponse, <-chan error) {
	responseChan := make(chan *StartBackupPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartBackupPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartBackupPlanWithCallback invokes the dbs.StartBackupPlan API asynchronously
func (client *Client) StartBackupPlanWithCallback(request *StartBackupPlanRequest, callback func(response *StartBackupPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartBackupPlanResponse
		var err error
		defer close(result)
		response, err = client.StartBackupPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartBackupPlanRequest is the request struct for api StartBackupPlan
type StartBackupPlanRequest struct {
	*requests.RpcRequest
	ClientToken  string `position:"Query" name:"ClientToken"`
	BackupPlanId string `position:"Query" name:"BackupPlanId"`
	OwnerId      string `position:"Query" name:"OwnerId"`
}

// StartBackupPlanResponse is the response struct for api StartBackupPlan
type StartBackupPlanResponse struct {
	*responses.BaseResponse
	HttpStatusCode         int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId              string `json:"RequestId" xml:"RequestId"`
	ErrCode                string `json:"ErrCode" xml:"ErrCode"`
	Success                bool   `json:"Success" xml:"Success"`
	ErrMessage             string `json:"ErrMessage" xml:"ErrMessage"`
	CreatedFullBackupsetId string `json:"CreatedFullBackupsetId" xml:"CreatedFullBackupsetId"`
	BackupPlanId           string `json:"BackupPlanId" xml:"BackupPlanId"`
}

// CreateStartBackupPlanRequest creates a request to invoke StartBackupPlan API
func CreateStartBackupPlanRequest() (request *StartBackupPlanRequest) {
	request = &StartBackupPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dbs", "2019-03-06", "StartBackupPlan", "", "")
	request.Method = requests.POST
	return
}

// CreateStartBackupPlanResponse creates a response to parse from StartBackupPlan response
func CreateStartBackupPlanResponse() (response *StartBackupPlanResponse) {
	response = &StartBackupPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
