package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateNodeRunMode invokes the dataworks_public.UpdateNodeRunMode API synchronously
func (client *Client) UpdateNodeRunMode(request *UpdateNodeRunModeRequest) (response *UpdateNodeRunModeResponse, err error) {
	response = CreateUpdateNodeRunModeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateNodeRunModeWithChan invokes the dataworks_public.UpdateNodeRunMode API asynchronously
func (client *Client) UpdateNodeRunModeWithChan(request *UpdateNodeRunModeRequest) (<-chan *UpdateNodeRunModeResponse, <-chan error) {
	responseChan := make(chan *UpdateNodeRunModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateNodeRunMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateNodeRunModeWithCallback invokes the dataworks_public.UpdateNodeRunMode API asynchronously
func (client *Client) UpdateNodeRunModeWithCallback(request *UpdateNodeRunModeRequest, callback func(response *UpdateNodeRunModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateNodeRunModeResponse
		var err error
		defer close(result)
		response, err = client.UpdateNodeRunMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateNodeRunModeRequest is the request struct for api UpdateNodeRunMode
type UpdateNodeRunModeRequest struct {
	*requests.RpcRequest
	ProjectEnv    string           `position:"Body" name:"ProjectEnv"`
	SchedulerType requests.Integer `position:"Body" name:"SchedulerType"`
	NodeId        requests.Integer `position:"Body" name:"NodeId"`
}

// UpdateNodeRunModeResponse is the response struct for api UpdateNodeRunMode
type UpdateNodeRunModeResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateNodeRunModeRequest creates a request to invoke UpdateNodeRunMode API
func CreateUpdateNodeRunModeRequest() (request *UpdateNodeRunModeRequest) {
	request = &UpdateNodeRunModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "UpdateNodeRunMode", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateNodeRunModeResponse creates a response to parse from UpdateNodeRunMode response
func CreateUpdateNodeRunModeResponse() (response *UpdateNodeRunModeResponse) {
	response = &UpdateNodeRunModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
